/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandlerV2;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.cloudhsm.AWSCloudHSM;
import com.amazonaws.services.cloudhsm.model.AddTagsToResourceRequest;
import com.amazonaws.services.cloudhsm.model.AddTagsToResourceResult;
import com.amazonaws.services.cloudhsm.model.CloudHsmInternalException;
import com.amazonaws.services.cloudhsm.model.CloudHsmServiceException;
import com.amazonaws.services.cloudhsm.model.CreateHapgRequest;
import com.amazonaws.services.cloudhsm.model.CreateHapgResult;
import com.amazonaws.services.cloudhsm.model.CreateHsmRequest;
import com.amazonaws.services.cloudhsm.model.CreateHsmResult;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.CreateLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DeleteHapgRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHapgResult;
import com.amazonaws.services.cloudhsm.model.DeleteHsmRequest;
import com.amazonaws.services.cloudhsm.model.DeleteHsmResult;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DeleteLunaClientResult;
import com.amazonaws.services.cloudhsm.model.DescribeHapgRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHapgResult;
import com.amazonaws.services.cloudhsm.model.DescribeHsmRequest;
import com.amazonaws.services.cloudhsm.model.DescribeHsmResult;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.DescribeLunaClientResult;
import com.amazonaws.services.cloudhsm.model.GetConfigRequest;
import com.amazonaws.services.cloudhsm.model.GetConfigResult;
import com.amazonaws.services.cloudhsm.model.InvalidRequestException;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesRequest;
import com.amazonaws.services.cloudhsm.model.ListAvailableZonesResult;
import com.amazonaws.services.cloudhsm.model.ListHapgsRequest;
import com.amazonaws.services.cloudhsm.model.ListHapgsResult;
import com.amazonaws.services.cloudhsm.model.ListHsmsRequest;
import com.amazonaws.services.cloudhsm.model.ListHsmsResult;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsRequest;
import com.amazonaws.services.cloudhsm.model.ListLunaClientsResult;
import com.amazonaws.services.cloudhsm.model.ListTagsForResourceRequest;
import com.amazonaws.services.cloudhsm.model.ListTagsForResourceResult;
import com.amazonaws.services.cloudhsm.model.ModifyHapgRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHapgResult;
import com.amazonaws.services.cloudhsm.model.ModifyHsmRequest;
import com.amazonaws.services.cloudhsm.model.ModifyHsmResult;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientRequest;
import com.amazonaws.services.cloudhsm.model.ModifyLunaClientResult;
import com.amazonaws.services.cloudhsm.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.cloudhsm.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.cloudhsm.model.transform.AddTagsToResourceRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.AddTagsToResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.CreateLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DeleteLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.DescribeLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.GetConfigRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.GetConfigResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListAvailableZonesRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListAvailableZonesResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHapgsRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHapgsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHsmsRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListHsmsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListLunaClientsRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListLunaClientsResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListTagsForResourceRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHapgRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHapgResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHsmRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyHsmResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyLunaClientRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.ModifyLunaClientResultJsonUnmarshaller;
import com.amazonaws.services.cloudhsm.model.transform.RemoveTagsFromResourceRequestMarshaller;
import com.amazonaws.services.cloudhsm.model.transform.RemoveTagsFromResourceResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshallerV2;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSCloudHSMClient
extends AmazonWebServiceClient
implements AWSCloudHSM {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSCloudHSM.class);
    private static final String DEFAULT_SIGNING_NAME = "cloudhsm";
    private static final String DEFAULT_ENDPOINT_PREFIX = "cloudhsm";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    protected List<JsonErrorUnmarshallerV2> jsonErrorUnmarshallers = new ArrayList<JsonErrorUnmarshallerV2>();

    public AWSCloudHSMClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AWSCloudHSMClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSCloudHSMClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AWSCloudHSMClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AWSCloudHSMClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(CloudHsmServiceException.class, "CloudHsmServiceException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(CloudHsmInternalException.class, "CloudHsmInternalException"));
        this.jsonErrorUnmarshallers.add(new JsonErrorUnmarshallerV2(InvalidRequestException.class, "InvalidRequestException"));
        this.jsonErrorUnmarshallers.add(JsonErrorUnmarshallerV2.DEFAULT_UNMARSHALLER);
        this.setServiceNameIntern("cloudhsm");
        this.setEndpointPrefix("cloudhsm");
        this.setEndpoint("https://cloudhsm.us-east-1.amazonaws.com/");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudhsm/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudhsm/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsToResourceResult addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(addTagsToResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AddTagsToResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AddTagsToResourceRequestMarshaller().marshall((AddTagsToResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)addTagsToResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new AddTagsToResourceResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            AddTagsToResourceResult addTagsToResourceResult = (AddTagsToResourceResult)response.getAwsResponse();
            return addTagsToResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHapgResult createHapg(CreateHapgRequest createHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHapgRequestMarshaller().marshall((CreateHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new CreateHapgResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateHapgResult createHapgResult = (CreateHapgResult)response.getAwsResponse();
            return createHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHsmResult createHsm(CreateHsmRequest createHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateHsmRequestMarshaller().marshall((CreateHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)createHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new CreateHsmResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateHsmResult createHsmResult = (CreateHsmResult)response.getAwsResponse();
            return createHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLunaClientResult createLunaClient(CreateLunaClientRequest createLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateLunaClientRequestMarshaller().marshall((CreateLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)createLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new CreateLunaClientResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateLunaClientResult createLunaClientResult = (CreateLunaClientResult)response.getAwsResponse();
            return createLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHapgResult deleteHapg(DeleteHapgRequest deleteHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHapgRequestMarshaller().marshall((DeleteHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DeleteHapgResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteHapgResult deleteHapgResult = (DeleteHapgResult)response.getAwsResponse();
            return deleteHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHsmResult deleteHsm(DeleteHsmRequest deleteHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHsmRequestMarshaller().marshall((DeleteHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DeleteHsmResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteHsmResult deleteHsmResult = (DeleteHsmResult)response.getAwsResponse();
            return deleteHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLunaClientResult deleteLunaClient(DeleteLunaClientRequest deleteLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteLunaClientRequestMarshaller().marshall((DeleteLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DeleteLunaClientResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DeleteLunaClientResult deleteLunaClientResult = (DeleteLunaClientResult)response.getAwsResponse();
            return deleteLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeHapgResult describeHapg(DescribeHapgRequest describeHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHapgRequestMarshaller().marshall((DescribeHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeHapgResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeHapgResult describeHapgResult = (DescribeHapgResult)response.getAwsResponse();
            return describeHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeHsmResult describeHsm(DescribeHsmRequest describeHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHsmRequestMarshaller().marshall((DescribeHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeHsmResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeHsmResult describeHsmResult = (DescribeHsmResult)response.getAwsResponse();
            return describeHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHsmResult describeHsm() {
        return this.describeHsm(new DescribeHsmRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLunaClientResult describeLunaClient(DescribeLunaClientRequest describeLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeLunaClientRequestMarshaller().marshall((DescribeLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new DescribeLunaClientResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeLunaClientResult describeLunaClientResult = (DescribeLunaClientResult)response.getAwsResponse();
            return describeLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeLunaClientResult describeLunaClient() {
        return this.describeLunaClient(new DescribeLunaClientRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfigResult getConfig(GetConfigRequest getConfigRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getConfigRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetConfigRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetConfigRequestMarshaller().marshall((GetConfigRequest)super.beforeMarshalling((AmazonWebServiceRequest)getConfigRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new GetConfigResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetConfigResult getConfigResult = (GetConfigResult)response.getAwsResponse();
            return getConfigResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAvailableZonesResult listAvailableZones(ListAvailableZonesRequest listAvailableZonesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAvailableZonesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAvailableZonesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAvailableZonesRequestMarshaller().marshall((ListAvailableZonesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAvailableZonesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListAvailableZonesResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListAvailableZonesResult listAvailableZonesResult = (ListAvailableZonesResult)response.getAwsResponse();
            return listAvailableZonesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAvailableZonesResult listAvailableZones() {
        return this.listAvailableZones(new ListAvailableZonesRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHapgsResult listHapgs(ListHapgsRequest listHapgsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHapgsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHapgsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHapgsRequestMarshaller().marshall((ListHapgsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHapgsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListHapgsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListHapgsResult listHapgsResult = (ListHapgsResult)response.getAwsResponse();
            return listHapgsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHapgsResult listHapgs() {
        return this.listHapgs(new ListHapgsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHsmsResult listHsms(ListHsmsRequest listHsmsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHsmsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHsmsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHsmsRequestMarshaller().marshall((ListHsmsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHsmsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListHsmsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListHsmsResult listHsmsResult = (ListHsmsResult)response.getAwsResponse();
            return listHsmsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHsmsResult listHsms() {
        return this.listHsms(new ListHsmsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListLunaClientsResult listLunaClients(ListLunaClientsRequest listLunaClientsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listLunaClientsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListLunaClientsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListLunaClientsRequestMarshaller().marshall((ListLunaClientsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listLunaClientsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListLunaClientsResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListLunaClientsResult listLunaClientsResult = (ListLunaClientsResult)response.getAwsResponse();
            return listLunaClientsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListLunaClientsResult listLunaClients() {
        return this.listLunaClients(new ListLunaClientsRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestMarshaller().marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyHapgResult modifyHapg(ModifyHapgRequest modifyHapgRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyHapgRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyHapgRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyHapgRequestMarshaller().marshall((ModifyHapgRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyHapgRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ModifyHapgResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ModifyHapgResult modifyHapgResult = (ModifyHapgResult)response.getAwsResponse();
            return modifyHapgResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyHsmResult modifyHsm(ModifyHsmRequest modifyHsmRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyHsmRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyHsmRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyHsmRequestMarshaller().marshall((ModifyHsmRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyHsmRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ModifyHsmResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ModifyHsmResult modifyHsmResult = (ModifyHsmResult)response.getAwsResponse();
            return modifyHsmResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyLunaClientResult modifyLunaClient(ModifyLunaClientRequest modifyLunaClientRequest) {
        ExecutionContext executionContext = this.createExecutionContext(modifyLunaClientRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ModifyLunaClientRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ModifyLunaClientRequestMarshaller().marshall((ModifyLunaClientRequest)super.beforeMarshalling((AmazonWebServiceRequest)modifyLunaClientRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new ModifyLunaClientResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ModifyLunaClientResult modifyLunaClientResult = (ModifyLunaClientResult)response.getAwsResponse();
            return modifyLunaClientResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsFromResourceResult removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTagsFromResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTagsFromResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTagsFromResourceRequestMarshaller().marshall((RemoveTagsFromResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTagsFromResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = SdkJsonProtocolFactory.createResponseHandler((Unmarshaller)new RemoveTagsFromResourceResultJsonUnmarshaller(), (boolean)false);
            responseHandler.setIsPayloadJson(true);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            RemoveTagsFromResourceResult removeTagsFromResourceResult = (RemoveTagsFromResourceResult)response.getAwsResponse();
            return removeTagsFromResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        JsonErrorResponseHandlerV2 errorResponseHandler = SdkJsonProtocolFactory.createErrorResponseHandler(this.jsonErrorUnmarshallers, (boolean)false);
        return this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
    }
}

