/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudhsm.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudhsm.model.ClientVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetConfigRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientArn;
    private String clientVersion;
    private ListWithAutoConstructFlag<String> hapgList;

    public String getClientArn() {
        return this.clientArn;
    }

    public void setClientArn(String clientArn) {
        this.clientArn = clientArn;
    }

    public GetConfigRequest withClientArn(String clientArn) {
        this.clientArn = clientArn;
        return this;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public GetConfigRequest withClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        return this;
    }

    public void setClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion.toString();
    }

    public GetConfigRequest withClientVersion(ClientVersion clientVersion) {
        this.clientVersion = clientVersion.toString();
        return this;
    }

    public List<String> getHapgList() {
        if (this.hapgList == null) {
            this.hapgList = new ListWithAutoConstructFlag();
            this.hapgList.setAutoConstruct(true);
        }
        return this.hapgList;
    }

    public void setHapgList(Collection<String> hapgList) {
        if (hapgList == null) {
            this.hapgList = null;
            return;
        }
        ListWithAutoConstructFlag hapgListCopy = new ListWithAutoConstructFlag(hapgList.size());
        hapgListCopy.addAll(hapgList);
        this.hapgList = hapgListCopy;
    }

    public GetConfigRequest withHapgList(String ... hapgList) {
        if (this.getHapgList() == null) {
            this.setHapgList(new ArrayList<String>(hapgList.length));
        }
        for (String value : hapgList) {
            this.getHapgList().add(value);
        }
        return this;
    }

    public GetConfigRequest withHapgList(Collection<String> hapgList) {
        if (hapgList == null) {
            this.hapgList = null;
        } else {
            ListWithAutoConstructFlag hapgListCopy = new ListWithAutoConstructFlag(hapgList.size());
            hapgListCopy.addAll(hapgList);
            this.hapgList = hapgListCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientArn() != null) {
            sb.append("ClientArn: " + this.getClientArn() + ",");
        }
        if (this.getClientVersion() != null) {
            sb.append("ClientVersion: " + this.getClientVersion() + ",");
        }
        if (this.getHapgList() != null) {
            sb.append("HapgList: " + this.getHapgList());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientArn() == null ? 0 : this.getClientArn().hashCode());
        hashCode = 31 * hashCode + (this.getClientVersion() == null ? 0 : this.getClientVersion().hashCode());
        hashCode = 31 * hashCode + (this.getHapgList() == null ? 0 : this.getHapgList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConfigRequest)) {
            return false;
        }
        GetConfigRequest other = (GetConfigRequest)obj;
        if (other.getClientArn() == null ^ this.getClientArn() == null) {
            return false;
        }
        if (other.getClientArn() != null && !other.getClientArn().equals(this.getClientArn())) {
            return false;
        }
        if (other.getClientVersion() == null ^ this.getClientVersion() == null) {
            return false;
        }
        if (other.getClientVersion() != null && !other.getClientVersion().equals(this.getClientVersion())) {
            return false;
        }
        if (other.getHapgList() == null ^ this.getHapgList() == null) {
            return false;
        }
        return other.getHapgList() == null || other.getHapgList().equals(this.getHapgList());
    }

    public GetConfigRequest clone() {
        return (GetConfigRequest)super.clone();
    }
}

