/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudfront.model.CachedMethods;
import com.amazonaws.services.cloudfront.model.Method;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AllowedMethods
implements Serializable {
    private Integer quantity;
    private ListWithAutoConstructFlag<String> items;
    private CachedMethods cachedMethods;

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public AllowedMethods withQuantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    public List<String> getItems() {
        if (this.items == null) {
            this.items = new ListWithAutoConstructFlag();
            this.items.setAutoConstruct(true);
        }
        return this.items;
    }

    public void setItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public AllowedMethods withItems(String ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<String>(items.length));
        }
        for (String value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public AllowedMethods withItems(Collection<String> items) {
        if (items == null) {
            this.items = null;
        } else {
            ListWithAutoConstructFlag itemsCopy = new ListWithAutoConstructFlag(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public AllowedMethods withItems(Method ... items) {
        ArrayList<String> itemsCopy = new ArrayList<String>(items.length);
        for (Method member : items) {
            itemsCopy.add(member.toString());
        }
        if (this.getItems() == null) {
            this.setItems(itemsCopy);
        } else {
            this.getItems().addAll(itemsCopy);
        }
        return this;
    }

    public CachedMethods getCachedMethods() {
        return this.cachedMethods;
    }

    public void setCachedMethods(CachedMethods cachedMethods) {
        this.cachedMethods = cachedMethods;
    }

    public AllowedMethods withCachedMethods(CachedMethods cachedMethods) {
        this.cachedMethods = cachedMethods;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQuantity() != null) {
            sb.append("Quantity: " + this.getQuantity() + ",");
        }
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems() + ",");
        }
        if (this.getCachedMethods() != null) {
            sb.append("CachedMethods: " + this.getCachedMethods());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQuantity() == null ? 0 : this.getQuantity().hashCode());
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : this.getItems().hashCode());
        hashCode = 31 * hashCode + (this.getCachedMethods() == null ? 0 : this.getCachedMethods().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllowedMethods)) {
            return false;
        }
        AllowedMethods other = (AllowedMethods)obj;
        if (other.getQuantity() == null ^ this.getQuantity() == null) {
            return false;
        }
        if (other.getQuantity() != null && !other.getQuantity().equals(this.getQuantity())) {
            return false;
        }
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !other.getItems().equals(this.getItems())) {
            return false;
        }
        if (other.getCachedMethods() == null ^ this.getCachedMethods() == null) {
            return false;
        }
        return other.getCachedMethods() == null || other.getCachedMethods().equals(this.getCachedMethods());
    }
}

