/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.transform.OriginSslProtocolsStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CustomOriginConfigStaxUnmarshaller
implements Unmarshaller<CustomOriginConfig, StaxUnmarshallerContext> {
    private static CustomOriginConfigStaxUnmarshaller instance;

    public CustomOriginConfig unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomOriginConfig customOriginConfig = new CustomOriginConfig();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return customOriginConfig;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HTTPPort", targetDepth)) {
                    customOriginConfig.setHTTPPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HTTPSPort", targetDepth)) {
                    customOriginConfig.setHTTPSPort(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OriginProtocolPolicy", targetDepth)) {
                    customOriginConfig.setOriginProtocolPolicy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("OriginSslProtocols", targetDepth)) continue;
                customOriginConfig.setOriginSslProtocols(OriginSslProtocolsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return customOriginConfig;
    }

    public static CustomOriginConfigStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CustomOriginConfigStaxUnmarshaller();
        }
        return instance;
    }
}

