/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.RollbackStackRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RollbackStackRequestMarshaller
implements Marshaller<Request<RollbackStackRequest>, RollbackStackRequest> {
    public Request<RollbackStackRequest> marshall(RollbackStackRequest rollbackStackRequest) {
        if (rollbackStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rollbackStackRequest, "AmazonCloudFormation");
        request.addParameter("Action", "RollbackStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (rollbackStackRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)rollbackStackRequest.getStackName()));
        }
        if (rollbackStackRequest.getRoleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)rollbackStackRequest.getRoleARN()));
        }
        if (rollbackStackRequest.getClientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)rollbackStackRequest.getClientRequestToken()));
        }
        if (rollbackStackRequest.getRetainExceptOnCreate() != null) {
            request.addParameter("RetainExceptOnCreate", StringUtils.fromBoolean((Boolean)rollbackStackRequest.getRetainExceptOnCreate()));
        }
        return request;
    }
}

