/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.BatchDetachObject;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;

public class BatchDetachObjectJsonMarshaller {
    private static BatchDetachObjectJsonMarshaller instance;

    public void marshall(BatchDetachObject batchDetachObject, StructuredJsonGenerator jsonGenerator) {
        if (batchDetachObject == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (batchDetachObject.getParentReference() != null) {
                jsonGenerator.writeFieldName("ParentReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(batchDetachObject.getParentReference(), jsonGenerator);
            }
            if (batchDetachObject.getLinkName() != null) {
                jsonGenerator.writeFieldName("LinkName").writeValue(batchDetachObject.getLinkName());
            }
            if (batchDetachObject.getBatchReferenceName() != null) {
                jsonGenerator.writeFieldName("BatchReferenceName").writeValue(batchDetachObject.getBatchReferenceName());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static BatchDetachObjectJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new BatchDetachObjectJsonMarshaller();
        }
        return instance;
    }
}

