/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.ConsistencyLevel;
import com.amazonaws.services.clouddirectory.model.ObjectAttributeRange;
import com.amazonaws.services.clouddirectory.model.ObjectReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListIndexRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private List<ObjectAttributeRange> rangesOnIndexedValues;
    private ObjectReference indexReference;
    private Integer maxResults;
    private String nextToken;
    private String consistencyLevel;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public ListIndexRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public List<ObjectAttributeRange> getRangesOnIndexedValues() {
        return this.rangesOnIndexedValues;
    }

    public void setRangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
        if (rangesOnIndexedValues == null) {
            this.rangesOnIndexedValues = null;
            return;
        }
        this.rangesOnIndexedValues = new ArrayList<ObjectAttributeRange>(rangesOnIndexedValues);
    }

    public ListIndexRequest withRangesOnIndexedValues(ObjectAttributeRange ... rangesOnIndexedValues) {
        if (this.rangesOnIndexedValues == null) {
            this.setRangesOnIndexedValues(new ArrayList<ObjectAttributeRange>(rangesOnIndexedValues.length));
        }
        for (ObjectAttributeRange ele : rangesOnIndexedValues) {
            this.rangesOnIndexedValues.add(ele);
        }
        return this;
    }

    public ListIndexRequest withRangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
        this.setRangesOnIndexedValues(rangesOnIndexedValues);
        return this;
    }

    public void setIndexReference(ObjectReference indexReference) {
        this.indexReference = indexReference;
    }

    public ObjectReference getIndexReference() {
        return this.indexReference;
    }

    public ListIndexRequest withIndexReference(ObjectReference indexReference) {
        this.setIndexReference(indexReference);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListIndexRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListIndexRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public ListIndexRequest withConsistencyLevel(String consistencyLevel) {
        this.setConsistencyLevel(consistencyLevel);
        return this;
    }

    @JsonIgnore
    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel.toString();
    }

    public ListIndexRequest withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getRangesOnIndexedValues() != null) {
            sb.append("RangesOnIndexedValues: ").append(this.getRangesOnIndexedValues()).append(",");
        }
        if (this.getIndexReference() != null) {
            sb.append("IndexReference: ").append(this.getIndexReference()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getConsistencyLevel() != null) {
            sb.append("ConsistencyLevel: ").append(this.getConsistencyLevel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndexRequest)) {
            return false;
        }
        ListIndexRequest other = (ListIndexRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getRangesOnIndexedValues() == null ^ this.getRangesOnIndexedValues() == null) {
            return false;
        }
        if (other.getRangesOnIndexedValues() != null && !other.getRangesOnIndexedValues().equals(this.getRangesOnIndexedValues())) {
            return false;
        }
        if (other.getIndexReference() == null ^ this.getIndexReference() == null) {
            return false;
        }
        if (other.getIndexReference() != null && !other.getIndexReference().equals(this.getIndexReference())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getConsistencyLevel() == null ^ this.getConsistencyLevel() == null) {
            return false;
        }
        return other.getConsistencyLevel() == null || other.getConsistencyLevel().equals(this.getConsistencyLevel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getRangesOnIndexedValues() == null ? 0 : this.getRangesOnIndexedValues().hashCode());
        hashCode = 31 * hashCode + (this.getIndexReference() == null ? 0 : this.getIndexReference().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getConsistencyLevel() == null ? 0 : this.getConsistencyLevel().hashCode());
        return hashCode;
    }

    public ListIndexRequest clone() {
        return (ListIndexRequest)super.clone();
    }
}

