/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudcontrolapi.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cloudcontrolapi.model.Operation;
import com.amazonaws.services.cloudcontrolapi.model.OperationStatus;
import com.amazonaws.services.cloudcontrolapi.model.transform.ResourceRequestStatusFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResourceRequestStatusFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> operations;
    private List<String> operationStatuses;

    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(Collection<String> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        this.operations = new ArrayList<String>(operations);
    }

    public ResourceRequestStatusFilter withOperations(String ... operations) {
        if (this.operations == null) {
            this.setOperations(new ArrayList<String>(operations.length));
        }
        for (String ele : operations) {
            this.operations.add(ele);
        }
        return this;
    }

    public ResourceRequestStatusFilter withOperations(Collection<String> operations) {
        this.setOperations(operations);
        return this;
    }

    public ResourceRequestStatusFilter withOperations(Operation ... operations) {
        ArrayList<String> operationsCopy = new ArrayList<String>(operations.length);
        for (Operation value : operations) {
            operationsCopy.add(value.toString());
        }
        if (this.getOperations() == null) {
            this.setOperations(operationsCopy);
        } else {
            this.getOperations().addAll(operationsCopy);
        }
        return this;
    }

    public List<String> getOperationStatuses() {
        return this.operationStatuses;
    }

    public void setOperationStatuses(Collection<String> operationStatuses) {
        if (operationStatuses == null) {
            this.operationStatuses = null;
            return;
        }
        this.operationStatuses = new ArrayList<String>(operationStatuses);
    }

    public ResourceRequestStatusFilter withOperationStatuses(String ... operationStatuses) {
        if (this.operationStatuses == null) {
            this.setOperationStatuses(new ArrayList<String>(operationStatuses.length));
        }
        for (String ele : operationStatuses) {
            this.operationStatuses.add(ele);
        }
        return this;
    }

    public ResourceRequestStatusFilter withOperationStatuses(Collection<String> operationStatuses) {
        this.setOperationStatuses(operationStatuses);
        return this;
    }

    public ResourceRequestStatusFilter withOperationStatuses(OperationStatus ... operationStatuses) {
        ArrayList<String> operationStatusesCopy = new ArrayList<String>(operationStatuses.length);
        for (OperationStatus value : operationStatuses) {
            operationStatusesCopy.add(value.toString());
        }
        if (this.getOperationStatuses() == null) {
            this.setOperationStatuses(operationStatusesCopy);
        } else {
            this.getOperationStatuses().addAll(operationStatusesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOperations() != null) {
            sb.append("Operations: ").append(this.getOperations()).append(",");
        }
        if (this.getOperationStatuses() != null) {
            sb.append("OperationStatuses: ").append(this.getOperationStatuses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceRequestStatusFilter)) {
            return false;
        }
        ResourceRequestStatusFilter other = (ResourceRequestStatusFilter)obj;
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (other.getOperations() != null && !other.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (other.getOperationStatuses() == null ^ this.getOperationStatuses() == null) {
            return false;
        }
        return other.getOperationStatuses() == null || other.getOperationStatuses().equals(this.getOperationStatuses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        hashCode = 31 * hashCode + (this.getOperationStatuses() == null ? 0 : this.getOperationStatuses().hashCode());
        return hashCode;
    }

    public ResourceRequestStatusFilter clone() {
        try {
            return (ResourceRequestStatusFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceRequestStatusFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

