/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkvoice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chimesdkvoice.model.PhoneNumber;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class PhoneNumberMarshaller {
    private static final MarshallingInfo<String> PHONENUMBERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhoneNumberId").build();
    private static final MarshallingInfo<String> E164PHONENUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("E164PhoneNumber").build();
    private static final MarshallingInfo<String> COUNTRY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Country").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> PRODUCTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductType").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> CAPABILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Capabilities").build();
    private static final MarshallingInfo<List> ASSOCIATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Associations").build();
    private static final MarshallingInfo<String> CALLINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CallingName").build();
    private static final MarshallingInfo<String> CALLINGNAMESTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CallingNameStatus").build();
    private static final MarshallingInfo<Date> CREATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> UPDATEDTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> DELETIONTIMESTAMP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeletionTimestamp").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> ORDERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OrderId").build();
    private static final PhoneNumberMarshaller instance = new PhoneNumberMarshaller();

    public static PhoneNumberMarshaller getInstance() {
        return instance;
    }

    public void marshall(PhoneNumber phoneNumber, ProtocolMarshaller protocolMarshaller) {
        if (phoneNumber == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)phoneNumber.getPhoneNumberId(), PHONENUMBERID_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getE164PhoneNumber(), E164PHONENUMBER_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getCountry(), COUNTRY_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getProductType(), PRODUCTTYPE_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getCapabilities(), CAPABILITIES_BINDING);
            protocolMarshaller.marshall(phoneNumber.getAssociations(), ASSOCIATIONS_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getCallingName(), CALLINGNAME_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getCallingNameStatus(), CALLINGNAMESTATUS_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getCreatedTimestamp(), CREATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getUpdatedTimestamp(), UPDATEDTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getDeletionTimestamp(), DELETIONTIMESTAMP_BINDING);
            protocolMarshaller.marshall((Object)phoneNumber.getOrderId(), ORDERID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

