/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.chimesdkmessaging.model.SubChannelSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSubChannelsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String channelArn;
    private List<SubChannelSummary> subChannels;
    private String nextToken;

    public void setChannelArn(String channelArn) {
        this.channelArn = channelArn;
    }

    public String getChannelArn() {
        return this.channelArn;
    }

    public ListSubChannelsResult withChannelArn(String channelArn) {
        this.setChannelArn(channelArn);
        return this;
    }

    public List<SubChannelSummary> getSubChannels() {
        return this.subChannels;
    }

    public void setSubChannels(Collection<SubChannelSummary> subChannels) {
        if (subChannels == null) {
            this.subChannels = null;
            return;
        }
        this.subChannels = new ArrayList<SubChannelSummary>(subChannels);
    }

    public ListSubChannelsResult withSubChannels(SubChannelSummary ... subChannels) {
        if (this.subChannels == null) {
            this.setSubChannels(new ArrayList<SubChannelSummary>(subChannels.length));
        }
        for (SubChannelSummary ele : subChannels) {
            this.subChannels.add(ele);
        }
        return this;
    }

    public ListSubChannelsResult withSubChannels(Collection<SubChannelSummary> subChannels) {
        this.setSubChannels(subChannels);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSubChannelsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getChannelArn() != null) {
            sb.append("ChannelArn: ").append(this.getChannelArn()).append(",");
        }
        if (this.getSubChannels() != null) {
            sb.append("SubChannels: ").append(this.getSubChannels()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSubChannelsResult)) {
            return false;
        }
        ListSubChannelsResult other = (ListSubChannelsResult)obj;
        if (other.getChannelArn() == null ^ this.getChannelArn() == null) {
            return false;
        }
        if (other.getChannelArn() != null && !other.getChannelArn().equals(this.getChannelArn())) {
            return false;
        }
        if (other.getSubChannels() == null ^ this.getSubChannels() == null) {
            return false;
        }
        if (other.getSubChannels() != null && !other.getSubChannels().equals(this.getSubChannels())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getChannelArn() == null ? 0 : this.getChannelArn().hashCode());
        hashCode = 31 * hashCode + (this.getSubChannels() == null ? 0 : this.getSubChannels().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSubChannelsResult clone() {
        try {
            return (ListSubChannelsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

