/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmeetings;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.chimesdkmeetings.AmazonChimeSDKMeetings;
import com.amazonaws.services.chimesdkmeetings.AmazonChimeSDKMeetingsClientBuilder;
import com.amazonaws.services.chimesdkmeetings.model.AmazonChimeSDKMeetingsException;
import com.amazonaws.services.chimesdkmeetings.model.BatchCreateAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.BatchCreateAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.CreateAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.CreateAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingRequest;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingResult;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingWithAttendeesRequest;
import com.amazonaws.services.chimesdkmeetings.model.CreateMeetingWithAttendeesResult;
import com.amazonaws.services.chimesdkmeetings.model.DeleteAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.DeleteAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.DeleteMeetingRequest;
import com.amazonaws.services.chimesdkmeetings.model.DeleteMeetingResult;
import com.amazonaws.services.chimesdkmeetings.model.GetAttendeeRequest;
import com.amazonaws.services.chimesdkmeetings.model.GetAttendeeResult;
import com.amazonaws.services.chimesdkmeetings.model.GetMeetingRequest;
import com.amazonaws.services.chimesdkmeetings.model.GetMeetingResult;
import com.amazonaws.services.chimesdkmeetings.model.ListAttendeesRequest;
import com.amazonaws.services.chimesdkmeetings.model.ListAttendeesResult;
import com.amazonaws.services.chimesdkmeetings.model.StartMeetingTranscriptionRequest;
import com.amazonaws.services.chimesdkmeetings.model.StartMeetingTranscriptionResult;
import com.amazonaws.services.chimesdkmeetings.model.StopMeetingTranscriptionRequest;
import com.amazonaws.services.chimesdkmeetings.model.StopMeetingTranscriptionResult;
import com.amazonaws.services.chimesdkmeetings.model.transform.BadRequestExceptionUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.BatchCreateAttendeeRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.BatchCreateAttendeeResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.CreateAttendeeRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.CreateAttendeeResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.CreateMeetingRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.CreateMeetingResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.CreateMeetingWithAttendeesRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.CreateMeetingWithAttendeesResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.DeleteAttendeeRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.DeleteAttendeeResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.DeleteMeetingRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.DeleteMeetingResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.ForbiddenExceptionUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.GetAttendeeRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.GetAttendeeResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.GetMeetingRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.GetMeetingResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.ListAttendeesRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.ListAttendeesResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.NotFoundExceptionUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.StartMeetingTranscriptionRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.StartMeetingTranscriptionResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.StopMeetingTranscriptionRequestProtocolMarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.StopMeetingTranscriptionResultJsonUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.UnauthorizedExceptionUnmarshaller;
import com.amazonaws.services.chimesdkmeetings.model.transform.UnprocessableEntityExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonChimeSDKMeetingsClient
extends AmazonWebServiceClient
implements AmazonChimeSDKMeetings {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonChimeSDKMeetings.class);
    private static final String DEFAULT_SIGNING_NAME = "chime";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnprocessableEntityException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnprocessableEntityExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("NotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)NotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceUnavailableException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceUnavailableExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UnauthorizedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)UnauthorizedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ForbiddenException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ForbiddenExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("BadRequestException").withExceptionUnmarshaller((JsonErrorUnmarshaller)BadRequestExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonChimeSDKMeetingsException.class));

    public static AmazonChimeSDKMeetingsClientBuilder builder() {
        return AmazonChimeSDKMeetingsClientBuilder.standard();
    }

    AmazonChimeSDKMeetingsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonChimeSDKMeetingsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("meetings-chime");
        this.setEndpoint("meetings-chime.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/chimesdkmeetings/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/chimesdkmeetings/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public BatchCreateAttendeeResult batchCreateAttendee(BatchCreateAttendeeRequest request) {
        request = (BatchCreateAttendeeRequest)this.beforeClientExecution(request);
        return this.executeBatchCreateAttendee(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final BatchCreateAttendeeResult executeBatchCreateAttendee(BatchCreateAttendeeRequest batchCreateAttendeeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCreateAttendeeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCreateAttendeeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCreateAttendeeRequestProtocolMarshaller(protocolFactory).marshall((BatchCreateAttendeeRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchCreateAttendeeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"BatchCreateAttendee");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchCreateAttendeeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCreateAttendeeResult batchCreateAttendeeResult = (BatchCreateAttendeeResult)response.getAwsResponse();
            return batchCreateAttendeeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateAttendeeResult createAttendee(CreateAttendeeRequest request) {
        request = (CreateAttendeeRequest)this.beforeClientExecution(request);
        return this.executeCreateAttendee(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateAttendeeResult executeCreateAttendee(CreateAttendeeRequest createAttendeeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createAttendeeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateAttendeeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateAttendeeRequestProtocolMarshaller(protocolFactory).marshall((CreateAttendeeRequest)super.beforeMarshalling((AmazonWebServiceRequest)createAttendeeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateAttendee");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateAttendeeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateAttendeeResult createAttendeeResult = (CreateAttendeeResult)response.getAwsResponse();
            return createAttendeeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMeetingResult createMeeting(CreateMeetingRequest request) {
        request = (CreateMeetingRequest)this.beforeClientExecution(request);
        return this.executeCreateMeeting(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMeetingResult executeCreateMeeting(CreateMeetingRequest createMeetingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMeetingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMeetingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMeetingRequestProtocolMarshaller(protocolFactory).marshall((CreateMeetingRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMeetingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMeeting");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMeetingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMeetingResult createMeetingResult = (CreateMeetingResult)response.getAwsResponse();
            return createMeetingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateMeetingWithAttendeesResult createMeetingWithAttendees(CreateMeetingWithAttendeesRequest request) {
        request = (CreateMeetingWithAttendeesRequest)this.beforeClientExecution(request);
        return this.executeCreateMeetingWithAttendees(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateMeetingWithAttendeesResult executeCreateMeetingWithAttendees(CreateMeetingWithAttendeesRequest createMeetingWithAttendeesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createMeetingWithAttendeesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateMeetingWithAttendeesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateMeetingWithAttendeesRequestProtocolMarshaller(protocolFactory).marshall((CreateMeetingWithAttendeesRequest)super.beforeMarshalling((AmazonWebServiceRequest)createMeetingWithAttendeesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateMeetingWithAttendees");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateMeetingWithAttendeesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateMeetingWithAttendeesResult createMeetingWithAttendeesResult = (CreateMeetingWithAttendeesResult)response.getAwsResponse();
            return createMeetingWithAttendeesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteAttendeeResult deleteAttendee(DeleteAttendeeRequest request) {
        request = (DeleteAttendeeRequest)this.beforeClientExecution(request);
        return this.executeDeleteAttendee(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAttendeeResult executeDeleteAttendee(DeleteAttendeeRequest deleteAttendeeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAttendeeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAttendeeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAttendeeRequestProtocolMarshaller(protocolFactory).marshall((DeleteAttendeeRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAttendeeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteAttendee");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAttendeeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAttendeeResult deleteAttendeeResult = (DeleteAttendeeResult)response.getAwsResponse();
            return deleteAttendeeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteMeetingResult deleteMeeting(DeleteMeetingRequest request) {
        request = (DeleteMeetingRequest)this.beforeClientExecution(request);
        return this.executeDeleteMeeting(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteMeetingResult executeDeleteMeeting(DeleteMeetingRequest deleteMeetingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteMeetingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteMeetingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteMeetingRequestProtocolMarshaller(protocolFactory).marshall((DeleteMeetingRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteMeetingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteMeeting");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteMeetingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteMeetingResult deleteMeetingResult = (DeleteMeetingResult)response.getAwsResponse();
            return deleteMeetingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetAttendeeResult getAttendee(GetAttendeeRequest request) {
        request = (GetAttendeeRequest)this.beforeClientExecution(request);
        return this.executeGetAttendee(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetAttendeeResult executeGetAttendee(GetAttendeeRequest getAttendeeRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAttendeeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAttendeeRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAttendeeRequestProtocolMarshaller(protocolFactory).marshall((GetAttendeeRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAttendeeRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetAttendee");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAttendeeResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAttendeeResult getAttendeeResult = (GetAttendeeResult)response.getAwsResponse();
            return getAttendeeResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetMeetingResult getMeeting(GetMeetingRequest request) {
        request = (GetMeetingRequest)this.beforeClientExecution(request);
        return this.executeGetMeeting(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetMeetingResult executeGetMeeting(GetMeetingRequest getMeetingRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getMeetingRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetMeetingRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetMeetingRequestProtocolMarshaller(protocolFactory).marshall((GetMeetingRequest)super.beforeMarshalling((AmazonWebServiceRequest)getMeetingRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetMeeting");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetMeetingResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetMeetingResult getMeetingResult = (GetMeetingResult)response.getAwsResponse();
            return getMeetingResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAttendeesResult listAttendees(ListAttendeesRequest request) {
        request = (ListAttendeesRequest)this.beforeClientExecution(request);
        return this.executeListAttendees(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAttendeesResult executeListAttendees(ListAttendeesRequest listAttendeesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAttendeesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAttendeesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAttendeesRequestProtocolMarshaller(protocolFactory).marshall((ListAttendeesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAttendeesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListAttendees");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAttendeesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAttendeesResult listAttendeesResult = (ListAttendeesResult)response.getAwsResponse();
            return listAttendeesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartMeetingTranscriptionResult startMeetingTranscription(StartMeetingTranscriptionRequest request) {
        request = (StartMeetingTranscriptionRequest)this.beforeClientExecution(request);
        return this.executeStartMeetingTranscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartMeetingTranscriptionResult executeStartMeetingTranscription(StartMeetingTranscriptionRequest startMeetingTranscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startMeetingTranscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartMeetingTranscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartMeetingTranscriptionRequestProtocolMarshaller(protocolFactory).marshall((StartMeetingTranscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)startMeetingTranscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartMeetingTranscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartMeetingTranscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartMeetingTranscriptionResult startMeetingTranscriptionResult = (StartMeetingTranscriptionResult)response.getAwsResponse();
            return startMeetingTranscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopMeetingTranscriptionResult stopMeetingTranscription(StopMeetingTranscriptionRequest request) {
        request = (StopMeetingTranscriptionRequest)this.beforeClientExecution(request);
        return this.executeStopMeetingTranscription(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopMeetingTranscriptionResult executeStopMeetingTranscription(StopMeetingTranscriptionRequest stopMeetingTranscriptionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopMeetingTranscriptionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopMeetingTranscriptionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopMeetingTranscriptionRequestProtocolMarshaller(protocolFactory).marshall((StopMeetingTranscriptionRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopMeetingTranscriptionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"Chime SDK Meetings");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopMeetingTranscription");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopMeetingTranscriptionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopMeetingTranscriptionResult stopMeetingTranscriptionResult = (StopMeetingTranscriptionResult)response.getAwsResponse();
            return stopMeetingTranscriptionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

