/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkmediapipelines.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-media-pipelines-2021-07-15/CreateMediaInsightsPipeline"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateMediaInsightsPipelineResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The media insights pipeline object.
     * </p>
     */
    private MediaInsightsPipeline mediaInsightsPipeline;

    /**
     * <p>
     * The media insights pipeline object.
     * </p>
     * 
     * @param mediaInsightsPipeline
     *        The media insights pipeline object.
     */

    public void setMediaInsightsPipeline(MediaInsightsPipeline mediaInsightsPipeline) {
        this.mediaInsightsPipeline = mediaInsightsPipeline;
    }

    /**
     * <p>
     * The media insights pipeline object.
     * </p>
     * 
     * @return The media insights pipeline object.
     */

    public MediaInsightsPipeline getMediaInsightsPipeline() {
        return this.mediaInsightsPipeline;
    }

    /**
     * <p>
     * The media insights pipeline object.
     * </p>
     * 
     * @param mediaInsightsPipeline
     *        The media insights pipeline object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateMediaInsightsPipelineResult withMediaInsightsPipeline(MediaInsightsPipeline mediaInsightsPipeline) {
        setMediaInsightsPipeline(mediaInsightsPipeline);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getMediaInsightsPipeline() != null)
            sb.append("MediaInsightsPipeline: ").append(getMediaInsightsPipeline());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateMediaInsightsPipelineResult == false)
            return false;
        CreateMediaInsightsPipelineResult other = (CreateMediaInsightsPipelineResult) obj;
        if (other.getMediaInsightsPipeline() == null ^ this.getMediaInsightsPipeline() == null)
            return false;
        if (other.getMediaInsightsPipeline() != null && other.getMediaInsightsPipeline().equals(this.getMediaInsightsPipeline()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getMediaInsightsPipeline() == null) ? 0 : getMediaInsightsPipeline().hashCode());
        return hashCode;
    }

    @Override
    public CreateMediaInsightsPipelineResult clone() {
        try {
            return (CreateMediaInsightsPipelineResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
