/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmediapipelines;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.chimesdkmediapipelines.AmazonChimeSDKMediaPipelinesAsync;
import com.amazonaws.services.chimesdkmediapipelines.AmazonChimeSDKMediaPipelinesAsyncClientBuilder;
import com.amazonaws.services.chimesdkmediapipelines.AmazonChimeSDKMediaPipelinesClient;
import com.amazonaws.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.CreateMediaCapturePipelineResult;
import com.amazonaws.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.DeleteMediaCapturePipelineResult;
import com.amazonaws.services.chimesdkmediapipelines.model.GetMediaCapturePipelineRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.GetMediaCapturePipelineResult;
import com.amazonaws.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.ListMediaCapturePipelinesResult;
import com.amazonaws.services.chimesdkmediapipelines.model.ListTagsForResourceRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.ListTagsForResourceResult;
import com.amazonaws.services.chimesdkmediapipelines.model.TagResourceRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.TagResourceResult;
import com.amazonaws.services.chimesdkmediapipelines.model.UntagResourceRequest;
import com.amazonaws.services.chimesdkmediapipelines.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonChimeSDKMediaPipelinesAsyncClient
extends AmazonChimeSDKMediaPipelinesClient
implements AmazonChimeSDKMediaPipelinesAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonChimeSDKMediaPipelinesAsyncClientBuilder asyncBuilder() {
        return AmazonChimeSDKMediaPipelinesAsyncClientBuilder.standard();
    }

    AmazonChimeSDKMediaPipelinesAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonChimeSDKMediaPipelinesAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CreateMediaCapturePipelineResult> createMediaCapturePipelineAsync(CreateMediaCapturePipelineRequest request) {
        return this.createMediaCapturePipelineAsync(request, null);
    }

    @Override
    public Future<CreateMediaCapturePipelineResult> createMediaCapturePipelineAsync(CreateMediaCapturePipelineRequest request, final AsyncHandler<CreateMediaCapturePipelineRequest, CreateMediaCapturePipelineResult> asyncHandler) {
        final CreateMediaCapturePipelineRequest finalRequest = (CreateMediaCapturePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMediaCapturePipelineResult>(){

            @Override
            public CreateMediaCapturePipelineResult call() throws Exception {
                CreateMediaCapturePipelineResult result = null;
                try {
                    result = AmazonChimeSDKMediaPipelinesAsyncClient.this.executeCreateMediaCapturePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteMediaCapturePipelineResult> deleteMediaCapturePipelineAsync(DeleteMediaCapturePipelineRequest request) {
        return this.deleteMediaCapturePipelineAsync(request, null);
    }

    @Override
    public Future<DeleteMediaCapturePipelineResult> deleteMediaCapturePipelineAsync(DeleteMediaCapturePipelineRequest request, final AsyncHandler<DeleteMediaCapturePipelineRequest, DeleteMediaCapturePipelineResult> asyncHandler) {
        final DeleteMediaCapturePipelineRequest finalRequest = (DeleteMediaCapturePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteMediaCapturePipelineResult>(){

            @Override
            public DeleteMediaCapturePipelineResult call() throws Exception {
                DeleteMediaCapturePipelineResult result = null;
                try {
                    result = AmazonChimeSDKMediaPipelinesAsyncClient.this.executeDeleteMediaCapturePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetMediaCapturePipelineResult> getMediaCapturePipelineAsync(GetMediaCapturePipelineRequest request) {
        return this.getMediaCapturePipelineAsync(request, null);
    }

    @Override
    public Future<GetMediaCapturePipelineResult> getMediaCapturePipelineAsync(GetMediaCapturePipelineRequest request, final AsyncHandler<GetMediaCapturePipelineRequest, GetMediaCapturePipelineResult> asyncHandler) {
        final GetMediaCapturePipelineRequest finalRequest = (GetMediaCapturePipelineRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetMediaCapturePipelineResult>(){

            @Override
            public GetMediaCapturePipelineResult call() throws Exception {
                GetMediaCapturePipelineResult result = null;
                try {
                    result = AmazonChimeSDKMediaPipelinesAsyncClient.this.executeGetMediaCapturePipeline(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMediaCapturePipelinesResult> listMediaCapturePipelinesAsync(ListMediaCapturePipelinesRequest request) {
        return this.listMediaCapturePipelinesAsync(request, null);
    }

    @Override
    public Future<ListMediaCapturePipelinesResult> listMediaCapturePipelinesAsync(ListMediaCapturePipelinesRequest request, final AsyncHandler<ListMediaCapturePipelinesRequest, ListMediaCapturePipelinesResult> asyncHandler) {
        final ListMediaCapturePipelinesRequest finalRequest = (ListMediaCapturePipelinesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListMediaCapturePipelinesResult>(){

            @Override
            public ListMediaCapturePipelinesResult call() throws Exception {
                ListMediaCapturePipelinesResult result = null;
                try {
                    result = AmazonChimeSDKMediaPipelinesAsyncClient.this.executeListMediaCapturePipelines(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonChimeSDKMediaPipelinesAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonChimeSDKMediaPipelinesAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonChimeSDKMediaPipelinesAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

