/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chime.model.transform.ProxyMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Proxy
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer defaultSessionExpiryMinutes;
    private Boolean disabled;
    private String fallBackPhoneNumber;
    private List<String> phoneNumberCountries;

    public void setDefaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
        this.defaultSessionExpiryMinutes = defaultSessionExpiryMinutes;
    }

    public Integer getDefaultSessionExpiryMinutes() {
        return this.defaultSessionExpiryMinutes;
    }

    public Proxy withDefaultSessionExpiryMinutes(Integer defaultSessionExpiryMinutes) {
        this.setDefaultSessionExpiryMinutes(defaultSessionExpiryMinutes);
        return this;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public Proxy withDisabled(Boolean disabled) {
        this.setDisabled(disabled);
        return this;
    }

    public Boolean isDisabled() {
        return this.disabled;
    }

    public void setFallBackPhoneNumber(String fallBackPhoneNumber) {
        this.fallBackPhoneNumber = fallBackPhoneNumber;
    }

    public String getFallBackPhoneNumber() {
        return this.fallBackPhoneNumber;
    }

    public Proxy withFallBackPhoneNumber(String fallBackPhoneNumber) {
        this.setFallBackPhoneNumber(fallBackPhoneNumber);
        return this;
    }

    public List<String> getPhoneNumberCountries() {
        return this.phoneNumberCountries;
    }

    public void setPhoneNumberCountries(Collection<String> phoneNumberCountries) {
        if (phoneNumberCountries == null) {
            this.phoneNumberCountries = null;
            return;
        }
        this.phoneNumberCountries = new ArrayList<String>(phoneNumberCountries);
    }

    public Proxy withPhoneNumberCountries(String ... phoneNumberCountries) {
        if (this.phoneNumberCountries == null) {
            this.setPhoneNumberCountries(new ArrayList<String>(phoneNumberCountries.length));
        }
        for (String ele : phoneNumberCountries) {
            this.phoneNumberCountries.add(ele);
        }
        return this;
    }

    public Proxy withPhoneNumberCountries(Collection<String> phoneNumberCountries) {
        this.setPhoneNumberCountries(phoneNumberCountries);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultSessionExpiryMinutes() != null) {
            sb.append("DefaultSessionExpiryMinutes: ").append(this.getDefaultSessionExpiryMinutes()).append(",");
        }
        if (this.getDisabled() != null) {
            sb.append("Disabled: ").append(this.getDisabled()).append(",");
        }
        if (this.getFallBackPhoneNumber() != null) {
            sb.append("FallBackPhoneNumber: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getPhoneNumberCountries() != null) {
            sb.append("PhoneNumberCountries: ").append(this.getPhoneNumberCountries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Proxy)) {
            return false;
        }
        Proxy other = (Proxy)obj;
        if (other.getDefaultSessionExpiryMinutes() == null ^ this.getDefaultSessionExpiryMinutes() == null) {
            return false;
        }
        if (other.getDefaultSessionExpiryMinutes() != null && !other.getDefaultSessionExpiryMinutes().equals(this.getDefaultSessionExpiryMinutes())) {
            return false;
        }
        if (other.getDisabled() == null ^ this.getDisabled() == null) {
            return false;
        }
        if (other.getDisabled() != null && !other.getDisabled().equals(this.getDisabled())) {
            return false;
        }
        if (other.getFallBackPhoneNumber() == null ^ this.getFallBackPhoneNumber() == null) {
            return false;
        }
        if (other.getFallBackPhoneNumber() != null && !other.getFallBackPhoneNumber().equals(this.getFallBackPhoneNumber())) {
            return false;
        }
        if (other.getPhoneNumberCountries() == null ^ this.getPhoneNumberCountries() == null) {
            return false;
        }
        return other.getPhoneNumberCountries() == null || other.getPhoneNumberCountries().equals(this.getPhoneNumberCountries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultSessionExpiryMinutes() == null ? 0 : this.getDefaultSessionExpiryMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getDisabled() == null ? 0 : this.getDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getFallBackPhoneNumber() == null ? 0 : this.getFallBackPhoneNumber().hashCode());
        hashCode = 31 * hashCode + (this.getPhoneNumberCountries() == null ? 0 : this.getPhoneNumberCountries().hashCode());
        return hashCode;
    }

    public Proxy clone() {
        try {
            return (Proxy)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProxyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

