/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chime;

import javax.annotation.Generated;

import com.amazonaws.services.chime.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonChime}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonChime implements AmazonChime {

    protected AbstractAmazonChime() {
    }

    @Override
    public AssociatePhoneNumberWithUserResult associatePhoneNumberWithUser(AssociatePhoneNumberWithUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociatePhoneNumbersWithVoiceConnectorResult associatePhoneNumbersWithVoiceConnector(AssociatePhoneNumbersWithVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchDeletePhoneNumberResult batchDeletePhoneNumber(BatchDeletePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchSuspendUserResult batchSuspendUser(BatchSuspendUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUnsuspendUserResult batchUnsuspendUser(BatchUnsuspendUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdatePhoneNumberResult batchUpdatePhoneNumber(BatchUpdatePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public BatchUpdateUserResult batchUpdateUser(BatchUpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountResult createAccount(CreateAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePhoneNumberOrderResult createPhoneNumberOrder(CreatePhoneNumberOrderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVoiceConnectorResult createVoiceConnector(CreateVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountResult deleteAccount(DeleteAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePhoneNumberResult deletePhoneNumber(DeletePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorResult deleteVoiceConnector(DeleteVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorOriginationResult deleteVoiceConnectorOrigination(DeleteVoiceConnectorOriginationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorTerminationResult deleteVoiceConnectorTermination(DeleteVoiceConnectorTerminationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVoiceConnectorTerminationCredentialsResult deleteVoiceConnectorTerminationCredentials(DeleteVoiceConnectorTerminationCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociatePhoneNumberFromUserResult disassociatePhoneNumberFromUser(DisassociatePhoneNumberFromUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociatePhoneNumbersFromVoiceConnectorResult disassociatePhoneNumbersFromVoiceConnector(DisassociatePhoneNumbersFromVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountResult getAccount(GetAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccountSettingsResult getAccountSettings(GetAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetGlobalSettingsResult getGlobalSettings(GetGlobalSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPhoneNumberResult getPhoneNumber(GetPhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPhoneNumberOrderResult getPhoneNumberOrder(GetPhoneNumberOrderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserResult getUser(GetUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetUserSettingsResult getUserSettings(GetUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorResult getVoiceConnector(GetVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorOriginationResult getVoiceConnectorOrigination(GetVoiceConnectorOriginationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorTerminationResult getVoiceConnectorTermination(GetVoiceConnectorTerminationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVoiceConnectorTerminationHealthResult getVoiceConnectorTerminationHealth(GetVoiceConnectorTerminationHealthRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public InviteUsersResult inviteUsers(InviteUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountsResult listAccounts(ListAccountsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPhoneNumberOrdersResult listPhoneNumberOrders(ListPhoneNumberOrdersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPhoneNumbersResult listPhoneNumbers(ListPhoneNumbersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVoiceConnectorTerminationCredentialsResult listVoiceConnectorTerminationCredentials(ListVoiceConnectorTerminationCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVoiceConnectorsResult listVoiceConnectors(ListVoiceConnectorsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public LogoutUserResult logoutUser(LogoutUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorOriginationResult putVoiceConnectorOrigination(PutVoiceConnectorOriginationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorTerminationResult putVoiceConnectorTermination(PutVoiceConnectorTerminationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutVoiceConnectorTerminationCredentialsResult putVoiceConnectorTerminationCredentials(PutVoiceConnectorTerminationCredentialsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetPersonalPINResult resetPersonalPIN(ResetPersonalPINRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RestorePhoneNumberResult restorePhoneNumber(RestorePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SearchAvailablePhoneNumbersResult searchAvailablePhoneNumbers(SearchAvailablePhoneNumbersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountResult updateAccount(UpdateAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAccountSettingsResult updateAccountSettings(UpdateAccountSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateGlobalSettingsResult updateGlobalSettings(UpdateGlobalSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePhoneNumberResult updatePhoneNumber(UpdatePhoneNumberRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserResult updateUser(UpdateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateUserSettingsResult updateUserSettings(UpdateUserSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVoiceConnectorResult updateVoiceConnector(UpdateVoiceConnectorRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
