/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.opensearch.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * <p>
 * Container for the response returned by the <code>DescribePackages</code> operation.
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribePackagesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Basic information about a package.
     * </p>
     */
    private java.util.List<PackageDetails> packageDetailsList;
    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Send the request again using the returned token to retrieve the next
     * page.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Basic information about a package.
     * </p>
     * 
     * @return Basic information about a package.
     */

    public java.util.List<PackageDetails> getPackageDetailsList() {
        return packageDetailsList;
    }

    /**
     * <p>
     * Basic information about a package.
     * </p>
     * 
     * @param packageDetailsList
     *        Basic information about a package.
     */

    public void setPackageDetailsList(java.util.Collection<PackageDetails> packageDetailsList) {
        if (packageDetailsList == null) {
            this.packageDetailsList = null;
            return;
        }

        this.packageDetailsList = new java.util.ArrayList<PackageDetails>(packageDetailsList);
    }

    /**
     * <p>
     * Basic information about a package.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setPackageDetailsList(java.util.Collection)} or {@link #withPackageDetailsList(java.util.Collection)} if
     * you want to override the existing values.
     * </p>
     * 
     * @param packageDetailsList
     *        Basic information about a package.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribePackagesResult withPackageDetailsList(PackageDetails... packageDetailsList) {
        if (this.packageDetailsList == null) {
            setPackageDetailsList(new java.util.ArrayList<PackageDetails>(packageDetailsList.length));
        }
        for (PackageDetails ele : packageDetailsList) {
            this.packageDetailsList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Basic information about a package.
     * </p>
     * 
     * @param packageDetailsList
     *        Basic information about a package.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribePackagesResult withPackageDetailsList(java.util.Collection<PackageDetails> packageDetailsList) {
        setPackageDetailsList(packageDetailsList);
        return this;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Send the request again using the returned token to retrieve the next
     * page.
     * </p>
     * 
     * @param nextToken
     *        When <code>nextToken</code> is returned, there are more results available. The value of
     *        <code>nextToken</code> is a unique pagination token for each page. Send the request again using the
     *        returned token to retrieve the next page.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Send the request again using the returned token to retrieve the next
     * page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Send the request again using the
     *         returned token to retrieve the next page.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Send the request again using the returned token to retrieve the next
     * page.
     * </p>
     * 
     * @param nextToken
     *        When <code>nextToken</code> is returned, there are more results available. The value of
     *        <code>nextToken</code> is a unique pagination token for each page. Send the request again using the
     *        returned token to retrieve the next page.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribePackagesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getPackageDetailsList() != null)
            sb.append("PackageDetailsList: ").append(getPackageDetailsList()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribePackagesResult == false)
            return false;
        DescribePackagesResult other = (DescribePackagesResult) obj;
        if (other.getPackageDetailsList() == null ^ this.getPackageDetailsList() == null)
            return false;
        if (other.getPackageDetailsList() != null && other.getPackageDetailsList().equals(this.getPackageDetailsList()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getPackageDetailsList() == null) ? 0 : getPackageDetailsList().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public DescribePackagesResult clone() {
        try {
            return (DescribePackagesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
