/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.jackson.databind.ser.std;

import com.amazonaws.thirdparty.jackson.core.JsonGenerator;
import com.amazonaws.thirdparty.jackson.databind.JavaType;
import com.amazonaws.thirdparty.jackson.databind.JsonMappingException;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.thirdparty.jackson.databind.SerializerProvider;
import com.amazonaws.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.amazonaws.thirdparty.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.thirdparty.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

public class RawSerializer<T>
extends StdSerializer<T> {
    public RawSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeRawValue(value.toString());
    }

    @Override
    public void serializeWithType(T value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectStringFormat(typeHint);
    }
}

