/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.TelemetryRecord;
import com.amazonaws.services.xray.model.transform.BackendConnectionErrorsJsonMarshaller;

public class TelemetryRecordJsonMarshaller {
    private static TelemetryRecordJsonMarshaller instance;

    public void marshall(TelemetryRecord telemetryRecord, StructuredJsonGenerator jsonGenerator) {
        if (telemetryRecord == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (telemetryRecord.getTimestamp() != null) {
                jsonGenerator.writeFieldName("Timestamp").writeValue(telemetryRecord.getTimestamp());
            }
            if (telemetryRecord.getSegmentsReceivedCount() != null) {
                jsonGenerator.writeFieldName("SegmentsReceivedCount").writeValue(telemetryRecord.getSegmentsReceivedCount());
            }
            if (telemetryRecord.getSegmentsSentCount() != null) {
                jsonGenerator.writeFieldName("SegmentsSentCount").writeValue(telemetryRecord.getSegmentsSentCount());
            }
            if (telemetryRecord.getSegmentsSpilloverCount() != null) {
                jsonGenerator.writeFieldName("SegmentsSpilloverCount").writeValue(telemetryRecord.getSegmentsSpilloverCount());
            }
            if (telemetryRecord.getSegmentsRejectedCount() != null) {
                jsonGenerator.writeFieldName("SegmentsRejectedCount").writeValue(telemetryRecord.getSegmentsRejectedCount());
            }
            if (telemetryRecord.getBackendConnectionErrors() != null) {
                jsonGenerator.writeFieldName("BackendConnectionErrors");
                BackendConnectionErrorsJsonMarshaller.getInstance().marshall(telemetryRecord.getBackendConnectionErrors(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TelemetryRecordJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TelemetryRecordJsonMarshaller();
        }
        return instance;
    }
}

