/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.ListObjectChildrenRequest;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListObjectChildrenRequestMarshaller
implements Marshaller<Request<ListObjectChildrenRequest>, ListObjectChildrenRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListObjectChildrenRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListObjectChildrenRequest> marshall(ListObjectChildrenRequest listObjectChildrenRequest) {
        if (listObjectChildrenRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListObjectChildrenRequest> request = new DefaultRequest<ListObjectChildrenRequest>(listObjectChildrenRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (listObjectChildrenRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(listObjectChildrenRequest.getDirectoryArn()));
        }
        if (listObjectChildrenRequest.getConsistencyLevel() != null) {
            request.addHeader("x-amz-consistency-level", StringUtils.fromString(listObjectChildrenRequest.getConsistencyLevel()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/object/children";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listObjectChildrenRequest.getObjectReference() != null) {
                jsonGenerator.writeFieldName("ObjectReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(listObjectChildrenRequest.getObjectReference(), jsonGenerator);
            }
            if (listObjectChildrenRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listObjectChildrenRequest.getNextToken());
            }
            if (listObjectChildrenRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listObjectChildrenRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

