/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.clouddirectory.model.DeleteSchemaRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteSchemaRequestMarshaller
implements Marshaller<Request<DeleteSchemaRequest>, DeleteSchemaRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteSchemaRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteSchemaRequest> marshall(DeleteSchemaRequest deleteSchemaRequest) {
        if (deleteSchemaRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteSchemaRequest> request = new DefaultRequest<DeleteSchemaRequest>(deleteSchemaRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (deleteSchemaRequest.getSchemaArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(deleteSchemaRequest.getSchemaArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/schema";
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

