/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.junit.spring;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DecisionContextProvider;
import com.amazonaws.services.simpleworkflow.flow.WorkflowException;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.generic.ContinueAsNewWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartChildWorkflowReply;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowDefinitionFactoryFactory;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOWorkflowImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.spring.POJOWorkflowStubImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.test.TestGenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.Map;

public class SpringTestPOJOWorkflowImplementationGenericWorkflowClient
implements GenericWorkflowClient {
    private final TestGenericWorkflowClient genericClient;
    private final Map<Class<?>, Object> workflowImplementations = new HashMap();

    public SpringTestPOJOWorkflowImplementationGenericWorkflowClient() {
        this.genericClient = new TestGenericWorkflowClient();
        this.genericClient.setFactoryFactory(new POJOWorkflowDefinitionFactoryFactory(){

            @Override
            protected POJOWorkflowImplementationFactory getImplementationFactory(Class<?> workflowImplementationType, Class<?> workflowInteface, WorkflowType workflowType) {
                Object instanceProxy = SpringTestPOJOWorkflowImplementationGenericWorkflowClient.this.workflowImplementations.get(workflowImplementationType);
                if (instanceProxy == null) {
                    throw new IllegalArgumentException("unknown workflowImplementationType: " + workflowImplementationType);
                }
                return new POJOWorkflowStubImplementationFactory(instanceProxy);
            }
        });
    }

    public void setWorkflowImplementations(Iterable<Object> workflowImplementations) throws InstantiationException, IllegalAccessException {
        for (Object workflowImplementation : workflowImplementations) {
            this.addWorkflowImplementation(workflowImplementation);
        }
    }

    public Iterable<Object> getWorkflowImplementations() {
        return this.workflowImplementations.values();
    }

    public void addWorkflowImplementation(Object workflowImplementation) throws InstantiationException, IllegalAccessException {
        Class<?> implementationClass = workflowImplementation.getClass();
        this.workflowImplementations.put(implementationClass, workflowImplementation);
        this.getFactoryFactory().addWorkflowImplementationType(implementationClass);
    }

    private POJOWorkflowDefinitionFactoryFactory getFactoryFactory() {
        return (POJOWorkflowDefinitionFactoryFactory)this.genericClient.getFactoryFactory();
    }

    public DecisionContextProvider getDecisionContextProvider() {
        return this.genericClient.getDecisionContextProvider();
    }

    public void setDecisionContextProvider(DecisionContextProvider decisionContextProvider) {
        this.genericClient.setDecisionContextProvider(decisionContextProvider);
    }

    @Override
    public Promise<StartChildWorkflowReply> startChildWorkflow(StartChildWorkflowExecutionParameters parameters) {
        return this.genericClient.startChildWorkflow(parameters);
    }

    @Override
    public Promise<String> startChildWorkflow(String workflow, String version, String input) {
        return this.genericClient.startChildWorkflow(workflow, version, input);
    }

    @Override
    public Promise<String> startChildWorkflow(String workflow, String version, Promise<String> input) {
        return this.genericClient.startChildWorkflow(workflow, version, input);
    }

    @Override
    public Promise<Void> signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters) {
        return this.genericClient.signalWorkflowExecution(signalParameters);
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        this.genericClient.requestCancelWorkflowExecution(execution);
    }

    public String getWorkflowState(WorkflowExecution execution) throws WorkflowException {
        return this.genericClient.getWorkflowState(execution);
    }

    @Override
    public void continueAsNewOnCompletion(ContinueAsNewWorkflowExecutionParameters parameters) {
        this.genericClient.continueAsNewOnCompletion(parameters);
    }

    @Override
    public String generateUniqueId() {
        return this.genericClient.generateUniqueId();
    }

    public DataConverter getDataConverter() {
        return this.getFactoryFactory().getDataConverter();
    }

    public void setDataConverter(DataConverter converter) {
        this.getFactoryFactory().setDataConverter(converter);
    }

    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.getFactoryFactory().getWorkflowTypesToRegister();
    }
}

