/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.CommandInvocation;
import com.amazonaws.services.simplesystemsmanagement.model.CommandPlugin;
import com.amazonaws.services.simplesystemsmanagement.model.transform.CommandPluginJsonMarshaller;
import com.amazonaws.services.simplesystemsmanagement.model.transform.NotificationConfigJsonMarshaller;

public class CommandInvocationJsonMarshaller {
    private static CommandInvocationJsonMarshaller instance;

    public void marshall(CommandInvocation commandInvocation, StructuredJsonGenerator jsonGenerator) {
        if (commandInvocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList commandPluginsList;
            jsonGenerator.writeStartObject();
            if (commandInvocation.getCommandId() != null) {
                jsonGenerator.writeFieldName("CommandId").writeValue(commandInvocation.getCommandId());
            }
            if (commandInvocation.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(commandInvocation.getInstanceId());
            }
            if (commandInvocation.getInstanceName() != null) {
                jsonGenerator.writeFieldName("InstanceName").writeValue(commandInvocation.getInstanceName());
            }
            if (commandInvocation.getComment() != null) {
                jsonGenerator.writeFieldName("Comment").writeValue(commandInvocation.getComment());
            }
            if (commandInvocation.getDocumentName() != null) {
                jsonGenerator.writeFieldName("DocumentName").writeValue(commandInvocation.getDocumentName());
            }
            if (commandInvocation.getRequestedDateTime() != null) {
                jsonGenerator.writeFieldName("RequestedDateTime").writeValue(commandInvocation.getRequestedDateTime());
            }
            if (commandInvocation.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(commandInvocation.getStatus());
            }
            if (commandInvocation.getStatusDetails() != null) {
                jsonGenerator.writeFieldName("StatusDetails").writeValue(commandInvocation.getStatusDetails());
            }
            if (commandInvocation.getTraceOutput() != null) {
                jsonGenerator.writeFieldName("TraceOutput").writeValue(commandInvocation.getTraceOutput());
            }
            if (commandInvocation.getStandardOutputUrl() != null) {
                jsonGenerator.writeFieldName("StandardOutputUrl").writeValue(commandInvocation.getStandardOutputUrl());
            }
            if (commandInvocation.getStandardErrorUrl() != null) {
                jsonGenerator.writeFieldName("StandardErrorUrl").writeValue(commandInvocation.getStandardErrorUrl());
            }
            if (!(commandPluginsList = (SdkInternalList)commandInvocation.getCommandPlugins()).isEmpty() || !commandPluginsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CommandPlugins");
                jsonGenerator.writeStartArray();
                for (CommandPlugin commandPluginsListValue : commandPluginsList) {
                    if (commandPluginsListValue == null) continue;
                    CommandPluginJsonMarshaller.getInstance().marshall(commandPluginsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (commandInvocation.getServiceRole() != null) {
                jsonGenerator.writeFieldName("ServiceRole").writeValue(commandInvocation.getServiceRole());
            }
            if (commandInvocation.getNotificationConfig() != null) {
                jsonGenerator.writeFieldName("NotificationConfig");
                NotificationConfigJsonMarshaller.getInstance().marshall(commandInvocation.getNotificationConfig(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CommandInvocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CommandInvocationJsonMarshaller();
        }
        return instance;
    }
}

