/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.pinpoint.model.DeleteApnsChannelRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;

public class DeleteApnsChannelRequestMarshaller
implements Marshaller<Request<DeleteApnsChannelRequest>, DeleteApnsChannelRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteApnsChannelRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteApnsChannelRequest> marshall(DeleteApnsChannelRequest deleteApnsChannelRequest) {
        if (deleteApnsChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteApnsChannelRequest> request = new DefaultRequest<DeleteApnsChannelRequest>(deleteApnsChannelRequest, "AmazonPinpoint");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/v1/apps/{application-id}/channels/apns";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "application-id", deleteApnsChannelRequest.getApplicationId());
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

