/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesisanalytics.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesisanalytics.model.DeleteApplicationReferenceDataSourceRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteApplicationReferenceDataSourceRequestMarshaller
implements Marshaller<Request<DeleteApplicationReferenceDataSourceRequest>, DeleteApplicationReferenceDataSourceRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteApplicationReferenceDataSourceRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteApplicationReferenceDataSourceRequest> marshall(DeleteApplicationReferenceDataSourceRequest deleteApplicationReferenceDataSourceRequest) {
        if (deleteApplicationReferenceDataSourceRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteApplicationReferenceDataSourceRequest> request = new DefaultRequest<DeleteApplicationReferenceDataSourceRequest>(deleteApplicationReferenceDataSourceRequest, "AmazonKinesisAnalytics");
        request.addHeader("X-Amz-Target", "KinesisAnalytics_20150814.DeleteApplicationReferenceDataSource");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteApplicationReferenceDataSourceRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("ApplicationName").writeValue(deleteApplicationReferenceDataSourceRequest.getApplicationName());
            }
            if (deleteApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId() != null) {
                jsonGenerator.writeFieldName("CurrentApplicationVersionId").writeValue(deleteApplicationReferenceDataSourceRequest.getCurrentApplicationVersionId());
            }
            if (deleteApplicationReferenceDataSourceRequest.getReferenceId() != null) {
                jsonGenerator.writeFieldName("ReferenceId").writeValue(deleteApplicationReferenceDataSourceRequest.getReferenceId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

