/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.DescribeFleetUtilizationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeFleetUtilizationRequestMarshaller
implements Marshaller<Request<DescribeFleetUtilizationRequest>, DescribeFleetUtilizationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeFleetUtilizationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeFleetUtilizationRequest> marshall(DescribeFleetUtilizationRequest describeFleetUtilizationRequest) {
        if (describeFleetUtilizationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeFleetUtilizationRequest> request = new DefaultRequest<DescribeFleetUtilizationRequest>(describeFleetUtilizationRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.DescribeFleetUtilization");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> fleetIdsList = describeFleetUtilizationRequest.getFleetIds();
            if (fleetIdsList != null) {
                jsonGenerator.writeFieldName("FleetIds");
                jsonGenerator.writeStartArray();
                for (String fleetIdsListValue : fleetIdsList) {
                    if (fleetIdsListValue == null) continue;
                    jsonGenerator.writeValue(fleetIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeFleetUtilizationRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeFleetUtilizationRequest.getLimit());
            }
            if (describeFleetUtilizationRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeFleetUtilizationRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

