/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetDownloadUrlForLayerRequestMarshaller
implements Marshaller<Request<GetDownloadUrlForLayerRequest>, GetDownloadUrlForLayerRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDownloadUrlForLayerRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDownloadUrlForLayerRequest> marshall(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) {
        if (getDownloadUrlForLayerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDownloadUrlForLayerRequest> request = new DefaultRequest<GetDownloadUrlForLayerRequest>(getDownloadUrlForLayerRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.GetDownloadUrlForLayer");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getDownloadUrlForLayerRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(getDownloadUrlForLayerRequest.getRegistryId());
            }
            if (getDownloadUrlForLayerRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(getDownloadUrlForLayerRequest.getRepositoryName());
            }
            if (getDownloadUrlForLayerRequest.getLayerDigest() != null) {
                jsonGenerator.writeFieldName("layerDigest").writeValue(getDownloadUrlForLayerRequest.getLayerDigest());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

