/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.ComputeResource;
import java.util.List;
import java.util.Map;

public class ComputeResourceJsonMarshaller {
    private static ComputeResourceJsonMarshaller instance;

    public void marshall(ComputeResource computeResource, StructuredJsonGenerator jsonGenerator) {
        if (computeResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> map;
            List<String> list;
            List<String> subnetsList;
            List<String> instanceTypesList;
            jsonGenerator.writeStartObject();
            if (computeResource.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(computeResource.getType());
            }
            if (computeResource.getMinvCpus() != null) {
                jsonGenerator.writeFieldName("minvCpus").writeValue(computeResource.getMinvCpus());
            }
            if (computeResource.getMaxvCpus() != null) {
                jsonGenerator.writeFieldName("maxvCpus").writeValue(computeResource.getMaxvCpus());
            }
            if (computeResource.getDesiredvCpus() != null) {
                jsonGenerator.writeFieldName("desiredvCpus").writeValue(computeResource.getDesiredvCpus());
            }
            if ((instanceTypesList = computeResource.getInstanceTypes()) != null) {
                jsonGenerator.writeFieldName("instanceTypes");
                jsonGenerator.writeStartArray();
                for (String string : instanceTypesList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((subnetsList = computeResource.getSubnets()) != null) {
                jsonGenerator.writeFieldName("subnets");
                jsonGenerator.writeStartArray();
                for (String string : subnetsList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = computeResource.getSecurityGroupIds()) != null) {
                jsonGenerator.writeFieldName("securityGroupIds");
                jsonGenerator.writeStartArray();
                for (String securityGroupIdsListValue : list) {
                    if (securityGroupIdsListValue == null) continue;
                    jsonGenerator.writeValue(securityGroupIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (computeResource.getEc2KeyPair() != null) {
                jsonGenerator.writeFieldName("ec2KeyPair").writeValue(computeResource.getEc2KeyPair());
            }
            if (computeResource.getInstanceRole() != null) {
                jsonGenerator.writeFieldName("instanceRole").writeValue(computeResource.getInstanceRole());
            }
            if ((map = computeResource.getTags()) != null) {
                jsonGenerator.writeFieldName("tags");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> tagsMapValue : map.entrySet()) {
                    if (tagsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(tagsMapValue.getKey());
                    jsonGenerator.writeValue(tagsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (computeResource.getBidPercentage() != null) {
                jsonGenerator.writeFieldName("bidPercentage").writeValue(computeResource.getBidPercentage());
            }
            if (computeResource.getSpotIamFleetRole() != null) {
                jsonGenerator.writeFieldName("spotIamFleetRole").writeValue(computeResource.getSpotIamFleetRole());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ComputeResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ComputeResourceJsonMarshaller();
        }
        return instance;
    }
}

