/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.CreateAuthorizerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.util.List;

public class CreateAuthorizerRequestMarshaller
implements Marshaller<Request<CreateAuthorizerRequest>, CreateAuthorizerRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateAuthorizerRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateAuthorizerRequest> marshall(CreateAuthorizerRequest createAuthorizerRequest) {
        if (createAuthorizerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateAuthorizerRequest> request = new DefaultRequest<CreateAuthorizerRequest>(createAuthorizerRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", createAuthorizerRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        try {
            List<String> providerARNsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createAuthorizerRequest.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(createAuthorizerRequest.getName());
            }
            if (createAuthorizerRequest.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(createAuthorizerRequest.getType());
            }
            if ((providerARNsList = createAuthorizerRequest.getProviderARNs()) != null) {
                jsonGenerator.writeFieldName("providerARNs");
                jsonGenerator.writeStartArray();
                for (String providerARNsListValue : providerARNsList) {
                    if (providerARNsListValue == null) continue;
                    jsonGenerator.writeValue(providerARNsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (createAuthorizerRequest.getAuthType() != null) {
                jsonGenerator.writeFieldName("authType").writeValue(createAuthorizerRequest.getAuthType());
            }
            if (createAuthorizerRequest.getAuthorizerUri() != null) {
                jsonGenerator.writeFieldName("authorizerUri").writeValue(createAuthorizerRequest.getAuthorizerUri());
            }
            if (createAuthorizerRequest.getAuthorizerCredentials() != null) {
                jsonGenerator.writeFieldName("authorizerCredentials").writeValue(createAuthorizerRequest.getAuthorizerCredentials());
            }
            if (createAuthorizerRequest.getIdentitySource() != null) {
                jsonGenerator.writeFieldName("identitySource").writeValue(createAuthorizerRequest.getIdentitySource());
            }
            if (createAuthorizerRequest.getIdentityValidationExpression() != null) {
                jsonGenerator.writeFieldName("identityValidationExpression").writeValue(createAuthorizerRequest.getIdentityValidationExpression());
            }
            if (createAuthorizerRequest.getAuthorizerResultTtlInSeconds() != null) {
                jsonGenerator.writeFieldName("authorizerResultTtlInSeconds").writeValue(createAuthorizerRequest.getAuthorizerResultTtlInSeconds());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

