/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.internal.validation;

import com.amazonaws.services.stepfunctions.builder.StateMachine;
import com.amazonaws.services.stepfunctions.builder.conditions.BinaryCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.Condition;
import com.amazonaws.services.stepfunctions.builder.conditions.NAryCondition;
import com.amazonaws.services.stepfunctions.builder.conditions.NotCondition;
import com.amazonaws.services.stepfunctions.builder.internal.validation.Location;
import com.amazonaws.services.stepfunctions.builder.internal.validation.Problem;
import com.amazonaws.services.stepfunctions.builder.internal.validation.ProblemReporter;
import com.amazonaws.services.stepfunctions.builder.internal.validation.ValidationContext;
import com.amazonaws.services.stepfunctions.builder.states.Branch;
import com.amazonaws.services.stepfunctions.builder.states.Catcher;
import com.amazonaws.services.stepfunctions.builder.states.Choice;
import com.amazonaws.services.stepfunctions.builder.states.ChoiceState;
import com.amazonaws.services.stepfunctions.builder.states.FailState;
import com.amazonaws.services.stepfunctions.builder.states.NextStateTransition;
import com.amazonaws.services.stepfunctions.builder.states.ParallelState;
import com.amazonaws.services.stepfunctions.builder.states.PassState;
import com.amazonaws.services.stepfunctions.builder.states.Retrier;
import com.amazonaws.services.stepfunctions.builder.states.State;
import com.amazonaws.services.stepfunctions.builder.states.StateVisitor;
import com.amazonaws.services.stepfunctions.builder.states.SucceedState;
import com.amazonaws.services.stepfunctions.builder.states.TaskState;
import com.amazonaws.services.stepfunctions.builder.states.Transition;
import com.amazonaws.services.stepfunctions.builder.states.TransitionState;
import com.amazonaws.services.stepfunctions.builder.states.WaitFor;
import com.amazonaws.services.stepfunctions.builder.states.WaitForSeconds;
import com.amazonaws.services.stepfunctions.builder.states.WaitForSecondsPath;
import com.amazonaws.services.stepfunctions.builder.states.WaitForTimestamp;
import com.amazonaws.services.stepfunctions.builder.states.WaitForTimestampPath;
import com.amazonaws.services.stepfunctions.builder.states.WaitState;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StateMachineValidator {
    private final ProblemReporter problemReporter = new ProblemReporter();
    private final StateMachine stateMachine;

    public StateMachineValidator(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
    }

    public StateMachine validate() {
        ValidationContext context = ValidationContext.builder().problemReporter(this.problemReporter).parentContext(null).identifier("Root").location(Location.StateMachine).build();
        context.assertStringNotEmpty(this.stateMachine.getStartAt(), "StartAt");
        context.assertIsPositiveIfPresent(this.stateMachine.getTimeoutSeconds(), "TimeoutSeconds");
        context.assertNotEmpty(this.stateMachine.getStates(), "States");
        this.validateStates(context, this.stateMachine.getStates());
        if (!this.stateMachine.getStates().containsKey(this.stateMachine.getStartAt())) {
            this.problemReporter.report(new Problem(context, String.format("%s state does not exist.", "StartAt")));
        }
        if (!this.problemReporter.hasProblems()) {
            new GraphValidator(context, this.stateMachine).validate();
        }
        if (this.problemReporter.hasProblems()) {
            throw this.problemReporter.getException();
        }
        return this.stateMachine;
    }

    private void validateStates(ValidationContext parentContext, Map<String, State> states) {
        for (Map.Entry<String, State> entry : states.entrySet()) {
            parentContext.assertStringNotEmpty(entry.getKey(), "State Name");
            entry.getValue().accept(new StateValidationVisitor(states, parentContext.state(entry.getKey())));
        }
    }

    private class StateValidationVisitor
    extends StateVisitor<Void> {
        private final ValidationContext currentContext;
        private final Map<String, State> states;

        private StateValidationVisitor(Map<String, State> states, ValidationContext context) {
            this.states = states;
            this.currentContext = context;
        }

        @Override
        public Void visit(ChoiceState choiceState) {
            this.currentContext.assertIsValidInputPath(choiceState.getInputPath());
            this.currentContext.assertIsValidOutputPath(choiceState.getOutputPath());
            if (choiceState.getDefaultStateName() != null) {
                this.currentContext.assertStringNotEmpty(choiceState.getDefaultStateName(), "Default");
                this.assertContainsState(choiceState.getDefaultStateName());
            }
            this.currentContext.assertNotEmpty(choiceState.getChoices(), "Choices");
            int index = 0;
            for (Choice choice : choiceState.getChoices()) {
                ValidationContext choiceContext = this.currentContext.choice(index);
                this.validateTransition(choiceContext, choice.getTransition());
                this.validateCondition(choiceContext, choice.getCondition());
                ++index;
            }
            return null;
        }

        private void validateCondition(ValidationContext context, Condition condition) {
            context.assertNotNull(condition, "Condition");
            if (condition instanceof BinaryCondition) {
                this.validateBinaryCondition(context, (BinaryCondition)condition);
            } else if (condition instanceof NAryCondition) {
                this.validateNAryCondition(context, (NAryCondition)condition);
            } else if (condition instanceof NotCondition) {
                this.validateCondition(context, ((NotCondition)condition).getCondition());
            } else if (condition != null) {
                throw new RuntimeException("Unsupported condition type: " + condition.getClass());
            }
        }

        private void validateNAryCondition(ValidationContext context, NAryCondition condition) {
            context.assertNotEmpty(condition.getConditions(), "Conditions");
            for (Condition nestedCondition : condition.getConditions()) {
                this.validateCondition(context, nestedCondition);
            }
        }

        private void validateBinaryCondition(ValidationContext context, BinaryCondition condition) {
            context.assertStringNotEmpty(condition.getVariable(), "Variable");
            context.assertIsValidJsonPath(condition.getVariable(), "Variable");
            context.assertNotNull(condition.getExpectedValue(), "ExpectedValue");
        }

        @Override
        public Void visit(FailState failState) {
            this.currentContext.assertStringNotEmpty(failState.getCause(), "Cause");
            return null;
        }

        @Override
        public Void visit(ParallelState parallelState) {
            this.currentContext.assertIsValidInputPath(parallelState.getInputPath());
            this.currentContext.assertIsValidOutputPath(parallelState.getOutputPath());
            this.currentContext.assertIsValidResultPath(parallelState.getResultPath());
            this.validateTransition(parallelState.getTransition());
            this.validateRetriers(parallelState.getRetriers());
            this.validateCatchers(parallelState.getCatchers());
            this.validateBranches(parallelState);
            return null;
        }

        private void validateBranches(ParallelState parallelState) {
            this.currentContext.assertNotEmpty(parallelState.getBranches(), "Branches");
            int index = 0;
            for (Branch branch : parallelState.getBranches()) {
                ValidationContext branchContext = this.currentContext.branch(index);
                StateMachineValidator.this.validateStates(branchContext, branch.getStates());
                if (!branch.getStates().containsKey(branch.getStartAt())) {
                    StateMachineValidator.this.problemReporter.report(new Problem(branchContext, String.format("%s references a non existent state.", "StartAt")));
                }
                ++index;
            }
        }

        @Override
        public Void visit(PassState passState) {
            this.currentContext.assertIsValidInputPath(passState.getInputPath());
            this.currentContext.assertIsValidOutputPath(passState.getOutputPath());
            this.currentContext.assertIsValidResultPath(passState.getResultPath());
            this.validateTransition(passState.getTransition());
            return null;
        }

        @Override
        public Void visit(SucceedState succeedState) {
            this.currentContext.assertIsValidInputPath(succeedState.getInputPath());
            this.currentContext.assertIsValidOutputPath(succeedState.getOutputPath());
            return null;
        }

        @Override
        public Void visit(TaskState taskState) {
            this.currentContext.assertIsValidInputPath(taskState.getInputPath());
            this.currentContext.assertIsValidOutputPath(taskState.getOutputPath());
            this.currentContext.assertIsValidResultPath(taskState.getResultPath());
            this.currentContext.assertIsPositiveIfPresent(taskState.getTimeoutSeconds(), "TimeoutSeconds");
            this.currentContext.assertIsPositiveIfPresent(taskState.getHeartbeatSeconds(), "HeartbeatSeconds");
            if (taskState.getTimeoutSeconds() != null && taskState.getHeartbeatSeconds() != null && taskState.getHeartbeatSeconds() >= taskState.getTimeoutSeconds()) {
                StateMachineValidator.this.problemReporter.report(new Problem(this.currentContext, String.format("%s must be smaller than %s", "HeartbeatSeconds", "TimeoutSeconds")));
            }
            this.currentContext.assertStringNotEmpty(taskState.getResource(), "Resource");
            this.validateRetriers(taskState.getRetriers());
            this.validateCatchers(taskState.getCatchers());
            this.validateTransition(taskState.getTransition());
            return null;
        }

        private void validateRetriers(List<Retrier> retriers) {
            boolean hasRetryAll = false;
            int index = 0;
            for (Retrier retrier : retriers) {
                ValidationContext retrierContext = this.currentContext.retrier(index);
                if (hasRetryAll) {
                    StateMachineValidator.this.problemReporter.report(new Problem(retrierContext, String.format("When %s is used in must be in the last Retrier", "States.ALL")));
                }
                retrierContext.assertIsNotNegativeIfPresent(retrier.getMaxAttempts(), "MaxAttempts");
                retrierContext.assertIsPositiveIfPresent(retrier.getIntervalSeconds(), "IntervalSeconds");
                if (retrier.getBackoffRate() != null && retrier.getBackoffRate() < 1.0) {
                    StateMachineValidator.this.problemReporter.report(new Problem(retrierContext, String.format("%s must be greater than or equal to 1.0", "BackoffRate")));
                }
                hasRetryAll = this.validateErrorEquals(retrierContext, retrier.getErrorEquals());
                ++index;
            }
        }

        private void validateCatchers(List<Catcher> catchers) {
            boolean hasCatchAll = false;
            int index = 0;
            for (Catcher catcher : catchers) {
                ValidationContext catcherContext = this.currentContext.catcher(index);
                catcherContext.assertIsValidResultPath(catcher.getResultPath());
                if (hasCatchAll) {
                    StateMachineValidator.this.problemReporter.report(new Problem(catcherContext, String.format("When %s is used in must be in the last Catcher", "States.ALL")));
                }
                this.validateTransition(catcherContext, catcher.getTransition());
                hasCatchAll = this.validateErrorEquals(catcherContext, catcher.getErrorEquals());
                ++index;
            }
        }

        private boolean validateErrorEquals(ValidationContext currentContext, List<String> errorEquals) {
            currentContext.assertNotEmpty(errorEquals, "ErrorEquals");
            if (errorEquals.contains("States.ALL")) {
                if (errorEquals.size() != 1) {
                    StateMachineValidator.this.problemReporter.report(new Problem(currentContext, String.format("When %s is used in %s, it must be the only error code in the array", "States.ALL", "ErrorEquals")));
                }
                return true;
            }
            return false;
        }

        @Override
        public Void visit(WaitState waitState) {
            this.currentContext.assertIsValidInputPath(waitState.getInputPath());
            this.currentContext.assertIsValidOutputPath(waitState.getOutputPath());
            this.validateTransition(waitState.getTransition());
            this.validateWaitFor(waitState.getWaitFor());
            return null;
        }

        private void validateWaitFor(WaitFor waitFor) {
            this.currentContext.assertNotNull(waitFor, "WaitFor");
            if (waitFor instanceof WaitForSeconds) {
                this.currentContext.assertIsPositiveIfPresent(((WaitForSeconds)waitFor).getSeconds(), "Seconds");
            } else if (waitFor instanceof WaitForSecondsPath) {
                this.assertWaitForPath(((WaitForSecondsPath)waitFor).getSecondsPath(), "SecondsPath");
            } else if (waitFor instanceof WaitForTimestamp) {
                this.currentContext.assertNotNull(((WaitForTimestamp)waitFor).getTimestamp(), "Timestamp");
            } else if (waitFor instanceof WaitForTimestampPath) {
                this.assertWaitForPath(((WaitForTimestampPath)waitFor).getTimestampPath(), "TimestampPath");
            } else if (waitFor != null) {
                throw new RuntimeException("Unsupported WaitFor strategy: " + waitFor.getClass());
            }
        }

        private void assertWaitForPath(String pathValue, String propertyName) {
            this.currentContext.assertNotNull(pathValue, propertyName);
            this.currentContext.assertIsValidReferencePath(pathValue, propertyName);
        }

        private void validateTransition(Transition transition) {
            this.validateTransition(this.currentContext, transition);
        }

        private void validateTransition(ValidationContext context, Transition transition) {
            context.assertNotNull(transition, "Transition");
            if (transition instanceof NextStateTransition) {
                String nextStateName = ((NextStateTransition)transition).getNextStateName();
                context.assertNotNull(nextStateName, "Next");
                this.assertContainsState(context, nextStateName);
            }
        }

        private void assertContainsState(String nextStateName) {
            this.assertContainsState(this.currentContext, nextStateName);
        }

        private void assertContainsState(ValidationContext context, String nextStateName) {
            if (!this.states.containsKey(nextStateName)) {
                StateMachineValidator.this.problemReporter.report(new Problem(context, String.format("%s is not a valid state", nextStateName)));
            }
        }
    }

    private final class GraphValidator {
        private final Map<String, State> parentVisited;
        private final String initialState;
        private final Map<String, State> states;
        private final Map<String, State> visited = new HashMap<String, State>();
        private final ValidationContext currentContext;

        public GraphValidator(ValidationContext context, StateMachine stateMachine) {
            this(context, Collections.emptyMap(), stateMachine.getStartAt(), stateMachine.getStates());
        }

        private GraphValidator(ValidationContext context, Map<String, State> parentVisited, String initialState, Map<String, State> states) {
            this.currentContext = context;
            this.parentVisited = parentVisited;
            this.initialState = initialState;
            this.states = states;
        }

        public boolean validate() {
            boolean pathToTerminal = this.visit(this.initialState);
            if (this.parentVisited.isEmpty() && !pathToTerminal) {
                StateMachineValidator.this.problemReporter.report(new Problem(this.currentContext, "No path to a terminal state exists."));
            }
            return pathToTerminal;
        }

        private boolean visit(String stateName) {
            ValidationContext stateContext = this.currentContext.state(stateName);
            State state = this.states.get(stateName);
            if (!this.parentVisited.containsKey(stateName) && this.visited.containsKey(stateName)) {
                StateMachineValidator.this.problemReporter.report(new Problem(stateContext, "Cycle detected."));
                return false;
            }
            if (this.parentVisited.containsKey(stateName)) {
                return false;
            }
            this.visited.put(stateName, state);
            if (state instanceof ParallelState) {
                this.validateParallelState(stateContext, (ParallelState)state);
            }
            if (state.isTerminalState()) {
                return true;
            }
            if (state instanceof TransitionState) {
                Transition transition = ((TransitionState)state).getTransition();
                return this.visit(((NextStateTransition)transition).getNextStateName());
            }
            if (state instanceof ChoiceState) {
                return this.validateChoiceState(stateContext, (ChoiceState)state);
            }
            throw new RuntimeException("Unexpected state type: " + state.getClass().getName());
        }

        private void validateParallelState(ValidationContext stateContext, ParallelState state) {
            int index = 0;
            for (Branch branch : state.getBranches()) {
                new GraphValidator(stateContext.branch(index), Collections.<String, State>emptyMap(), branch.getStartAt(), branch.getStates()).validate();
                ++index;
            }
        }

        private boolean validateChoiceState(ValidationContext stateContext, ChoiceState choiceState) {
            Map<String, State> merged = this.mergeParentVisited();
            boolean hasPathToTerminal = new GraphValidator(stateContext, merged, choiceState.getDefaultStateName(), this.states).validate();
            int index = 0;
            for (Choice choice : choiceState.getChoices()) {
                String nextStateName = ((NextStateTransition)choice.getTransition()).getNextStateName();
                hasPathToTerminal = new GraphValidator(stateContext.choice(index), merged, nextStateName, this.states).validate() || hasPathToTerminal;
                ++index;
            }
            return hasPathToTerminal;
        }

        private Map<String, State> mergeParentVisited() {
            HashMap<String, State> merged = new HashMap<String, State>(this.parentVisited.size() + this.visited.size());
            merged.putAll(this.parentVisited);
            merged.putAll(this.visited);
            return merged;
        }
    }
}

