/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.shield.model.ListProtectionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListProtectionsRequestMarshaller
implements Marshaller<Request<ListProtectionsRequest>, ListProtectionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListProtectionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListProtectionsRequest> marshall(ListProtectionsRequest listProtectionsRequest) {
        if (listProtectionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListProtectionsRequest> request = new DefaultRequest<ListProtectionsRequest>(listProtectionsRequest, "AWSShield");
        request.addHeader("X-Amz-Target", "AWSShield_20160616.ListProtections");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listProtectionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listProtectionsRequest.getNextToken());
            }
            if (listProtectionsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listProtectionsRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

