/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticfilesystem.model.CreateFileSystemRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class CreateFileSystemRequestMarshaller
implements Marshaller<Request<CreateFileSystemRequest>, CreateFileSystemRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateFileSystemRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateFileSystemRequest> marshall(CreateFileSystemRequest createFileSystemRequest) {
        if (createFileSystemRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateFileSystemRequest> request = new DefaultRequest<CreateFileSystemRequest>(createFileSystemRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-02-01/file-systems";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createFileSystemRequest.getCreationToken() != null) {
                jsonGenerator.writeFieldName("CreationToken").writeValue(createFileSystemRequest.getCreationToken());
            }
            if (createFileSystemRequest.getPerformanceMode() != null) {
                jsonGenerator.writeFieldName("PerformanceMode").writeValue(createFileSystemRequest.getPerformanceMode());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

