/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.directconnect.AmazonDirectConnectAsync;
import com.amazonaws.services.directconnect.AmazonDirectConnectClient;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectResult;
import com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.AllocatePrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.AllocatePublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.ConfirmConnectionRequest;
import com.amazonaws.services.directconnect.model.ConfirmConnectionResult;
import com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.ConfirmPrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.ConfirmPublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.CreateBGPPeerRequest;
import com.amazonaws.services.directconnect.model.CreateBGPPeerResult;
import com.amazonaws.services.directconnect.model.CreateConnectionRequest;
import com.amazonaws.services.directconnect.model.CreateConnectionResult;
import com.amazonaws.services.directconnect.model.CreateInterconnectRequest;
import com.amazonaws.services.directconnect.model.CreateInterconnectResult;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePrivateVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.CreatePublicVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DeleteBGPPeerRequest;
import com.amazonaws.services.directconnect.model.DeleteBGPPeerResult;
import com.amazonaws.services.directconnect.model.DeleteConnectionRequest;
import com.amazonaws.services.directconnect.model.DeleteConnectionResult;
import com.amazonaws.services.directconnect.model.DeleteInterconnectRequest;
import com.amazonaws.services.directconnect.model.DeleteInterconnectResult;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceRequest;
import com.amazonaws.services.directconnect.model.DeleteVirtualInterfaceResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionLoaRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionLoaResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionsOnInterconnectResult;
import com.amazonaws.services.directconnect.model.DescribeConnectionsRequest;
import com.amazonaws.services.directconnect.model.DescribeConnectionsResult;
import com.amazonaws.services.directconnect.model.DescribeInterconnectLoaRequest;
import com.amazonaws.services.directconnect.model.DescribeInterconnectLoaResult;
import com.amazonaws.services.directconnect.model.DescribeInterconnectsRequest;
import com.amazonaws.services.directconnect.model.DescribeInterconnectsResult;
import com.amazonaws.services.directconnect.model.DescribeLocationsRequest;
import com.amazonaws.services.directconnect.model.DescribeLocationsResult;
import com.amazonaws.services.directconnect.model.DescribeTagsRequest;
import com.amazonaws.services.directconnect.model.DescribeTagsResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualGatewaysResult;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesRequest;
import com.amazonaws.services.directconnect.model.DescribeVirtualInterfacesResult;
import com.amazonaws.services.directconnect.model.TagResourceRequest;
import com.amazonaws.services.directconnect.model.TagResourceResult;
import com.amazonaws.services.directconnect.model.UntagResourceRequest;
import com.amazonaws.services.directconnect.model.UntagResourceResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonDirectConnectAsyncClient
extends AmazonDirectConnectClient
implements AmazonDirectConnectAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonDirectConnectAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonDirectConnectAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonDirectConnectAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AllocateConnectionOnInterconnectResult> allocateConnectionOnInterconnectAsync(AllocateConnectionOnInterconnectRequest request) {
        return this.allocateConnectionOnInterconnectAsync(request, null);
    }

    @Override
    public Future<AllocateConnectionOnInterconnectResult> allocateConnectionOnInterconnectAsync(final AllocateConnectionOnInterconnectRequest request, final AsyncHandler<AllocateConnectionOnInterconnectRequest, AllocateConnectionOnInterconnectResult> asyncHandler) {
        return this.executorService.submit(new Callable<AllocateConnectionOnInterconnectResult>(){

            @Override
            public AllocateConnectionOnInterconnectResult call() throws Exception {
                AllocateConnectionOnInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.allocateConnectionOnInterconnect(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AllocatePrivateVirtualInterfaceResult> allocatePrivateVirtualInterfaceAsync(AllocatePrivateVirtualInterfaceRequest request) {
        return this.allocatePrivateVirtualInterfaceAsync(request, null);
    }

    @Override
    public Future<AllocatePrivateVirtualInterfaceResult> allocatePrivateVirtualInterfaceAsync(final AllocatePrivateVirtualInterfaceRequest request, final AsyncHandler<AllocatePrivateVirtualInterfaceRequest, AllocatePrivateVirtualInterfaceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AllocatePrivateVirtualInterfaceResult>(){

            @Override
            public AllocatePrivateVirtualInterfaceResult call() throws Exception {
                AllocatePrivateVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.allocatePrivateVirtualInterface(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AllocatePublicVirtualInterfaceResult> allocatePublicVirtualInterfaceAsync(AllocatePublicVirtualInterfaceRequest request) {
        return this.allocatePublicVirtualInterfaceAsync(request, null);
    }

    @Override
    public Future<AllocatePublicVirtualInterfaceResult> allocatePublicVirtualInterfaceAsync(final AllocatePublicVirtualInterfaceRequest request, final AsyncHandler<AllocatePublicVirtualInterfaceRequest, AllocatePublicVirtualInterfaceResult> asyncHandler) {
        return this.executorService.submit(new Callable<AllocatePublicVirtualInterfaceResult>(){

            @Override
            public AllocatePublicVirtualInterfaceResult call() throws Exception {
                AllocatePublicVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.allocatePublicVirtualInterface(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmConnectionResult> confirmConnectionAsync(ConfirmConnectionRequest request) {
        return this.confirmConnectionAsync(request, null);
    }

    @Override
    public Future<ConfirmConnectionResult> confirmConnectionAsync(final ConfirmConnectionRequest request, final AsyncHandler<ConfirmConnectionRequest, ConfirmConnectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmConnectionResult>(){

            @Override
            public ConfirmConnectionResult call() throws Exception {
                ConfirmConnectionResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.confirmConnection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmPrivateVirtualInterfaceResult> confirmPrivateVirtualInterfaceAsync(ConfirmPrivateVirtualInterfaceRequest request) {
        return this.confirmPrivateVirtualInterfaceAsync(request, null);
    }

    @Override
    public Future<ConfirmPrivateVirtualInterfaceResult> confirmPrivateVirtualInterfaceAsync(final ConfirmPrivateVirtualInterfaceRequest request, final AsyncHandler<ConfirmPrivateVirtualInterfaceRequest, ConfirmPrivateVirtualInterfaceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmPrivateVirtualInterfaceResult>(){

            @Override
            public ConfirmPrivateVirtualInterfaceResult call() throws Exception {
                ConfirmPrivateVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.confirmPrivateVirtualInterface(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConfirmPublicVirtualInterfaceResult> confirmPublicVirtualInterfaceAsync(ConfirmPublicVirtualInterfaceRequest request) {
        return this.confirmPublicVirtualInterfaceAsync(request, null);
    }

    @Override
    public Future<ConfirmPublicVirtualInterfaceResult> confirmPublicVirtualInterfaceAsync(final ConfirmPublicVirtualInterfaceRequest request, final AsyncHandler<ConfirmPublicVirtualInterfaceRequest, ConfirmPublicVirtualInterfaceResult> asyncHandler) {
        return this.executorService.submit(new Callable<ConfirmPublicVirtualInterfaceResult>(){

            @Override
            public ConfirmPublicVirtualInterfaceResult call() throws Exception {
                ConfirmPublicVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.confirmPublicVirtualInterface(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBGPPeerResult> createBGPPeerAsync(CreateBGPPeerRequest request) {
        return this.createBGPPeerAsync(request, null);
    }

    @Override
    public Future<CreateBGPPeerResult> createBGPPeerAsync(final CreateBGPPeerRequest request, final AsyncHandler<CreateBGPPeerRequest, CreateBGPPeerResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateBGPPeerResult>(){

            @Override
            public CreateBGPPeerResult call() throws Exception {
                CreateBGPPeerResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createBGPPeer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(CreateConnectionRequest request) {
        return this.createConnectionAsync(request, null);
    }

    @Override
    public Future<CreateConnectionResult> createConnectionAsync(final CreateConnectionRequest request, final AsyncHandler<CreateConnectionRequest, CreateConnectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateConnectionResult>(){

            @Override
            public CreateConnectionResult call() throws Exception {
                CreateConnectionResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createConnection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateInterconnectResult> createInterconnectAsync(CreateInterconnectRequest request) {
        return this.createInterconnectAsync(request, null);
    }

    @Override
    public Future<CreateInterconnectResult> createInterconnectAsync(final CreateInterconnectRequest request, final AsyncHandler<CreateInterconnectRequest, CreateInterconnectResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateInterconnectResult>(){

            @Override
            public CreateInterconnectResult call() throws Exception {
                CreateInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createInterconnect(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePrivateVirtualInterfaceResult> createPrivateVirtualInterfaceAsync(CreatePrivateVirtualInterfaceRequest request) {
        return this.createPrivateVirtualInterfaceAsync(request, null);
    }

    @Override
    public Future<CreatePrivateVirtualInterfaceResult> createPrivateVirtualInterfaceAsync(final CreatePrivateVirtualInterfaceRequest request, final AsyncHandler<CreatePrivateVirtualInterfaceRequest, CreatePrivateVirtualInterfaceResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePrivateVirtualInterfaceResult>(){

            @Override
            public CreatePrivateVirtualInterfaceResult call() throws Exception {
                CreatePrivateVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createPrivateVirtualInterface(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePublicVirtualInterfaceResult> createPublicVirtualInterfaceAsync(CreatePublicVirtualInterfaceRequest request) {
        return this.createPublicVirtualInterfaceAsync(request, null);
    }

    @Override
    public Future<CreatePublicVirtualInterfaceResult> createPublicVirtualInterfaceAsync(final CreatePublicVirtualInterfaceRequest request, final AsyncHandler<CreatePublicVirtualInterfaceRequest, CreatePublicVirtualInterfaceResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreatePublicVirtualInterfaceResult>(){

            @Override
            public CreatePublicVirtualInterfaceResult call() throws Exception {
                CreatePublicVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.createPublicVirtualInterface(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBGPPeerResult> deleteBGPPeerAsync(DeleteBGPPeerRequest request) {
        return this.deleteBGPPeerAsync(request, null);
    }

    @Override
    public Future<DeleteBGPPeerResult> deleteBGPPeerAsync(final DeleteBGPPeerRequest request, final AsyncHandler<DeleteBGPPeerRequest, DeleteBGPPeerResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteBGPPeerResult>(){

            @Override
            public DeleteBGPPeerResult call() throws Exception {
                DeleteBGPPeerResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.deleteBGPPeer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(DeleteConnectionRequest request) {
        return this.deleteConnectionAsync(request, null);
    }

    @Override
    public Future<DeleteConnectionResult> deleteConnectionAsync(final DeleteConnectionRequest request, final AsyncHandler<DeleteConnectionRequest, DeleteConnectionResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteConnectionResult>(){

            @Override
            public DeleteConnectionResult call() throws Exception {
                DeleteConnectionResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.deleteConnection(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteInterconnectResult> deleteInterconnectAsync(DeleteInterconnectRequest request) {
        return this.deleteInterconnectAsync(request, null);
    }

    @Override
    public Future<DeleteInterconnectResult> deleteInterconnectAsync(final DeleteInterconnectRequest request, final AsyncHandler<DeleteInterconnectRequest, DeleteInterconnectResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteInterconnectResult>(){

            @Override
            public DeleteInterconnectResult call() throws Exception {
                DeleteInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.deleteInterconnect(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVirtualInterfaceResult> deleteVirtualInterfaceAsync(DeleteVirtualInterfaceRequest request) {
        return this.deleteVirtualInterfaceAsync(request, null);
    }

    @Override
    public Future<DeleteVirtualInterfaceResult> deleteVirtualInterfaceAsync(final DeleteVirtualInterfaceRequest request, final AsyncHandler<DeleteVirtualInterfaceRequest, DeleteVirtualInterfaceResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteVirtualInterfaceResult>(){

            @Override
            public DeleteVirtualInterfaceResult call() throws Exception {
                DeleteVirtualInterfaceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.deleteVirtualInterface(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectionLoaResult> describeConnectionLoaAsync(DescribeConnectionLoaRequest request) {
        return this.describeConnectionLoaAsync(request, null);
    }

    @Override
    public Future<DescribeConnectionLoaResult> describeConnectionLoaAsync(final DescribeConnectionLoaRequest request, final AsyncHandler<DescribeConnectionLoaRequest, DescribeConnectionLoaResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConnectionLoaResult>(){

            @Override
            public DescribeConnectionLoaResult call() throws Exception {
                DescribeConnectionLoaResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeConnectionLoa(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectionsResult> describeConnectionsAsync(DescribeConnectionsRequest request) {
        return this.describeConnectionsAsync(request, null);
    }

    @Override
    public Future<DescribeConnectionsResult> describeConnectionsAsync(final DescribeConnectionsRequest request, final AsyncHandler<DescribeConnectionsRequest, DescribeConnectionsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConnectionsResult>(){

            @Override
            public DescribeConnectionsResult call() throws Exception {
                DescribeConnectionsResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeConnections(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConnectionsResult> describeConnectionsAsync() {
        return this.describeConnectionsAsync(new DescribeConnectionsRequest());
    }

    @Override
    public Future<DescribeConnectionsResult> describeConnectionsAsync(AsyncHandler<DescribeConnectionsRequest, DescribeConnectionsResult> asyncHandler) {
        return this.describeConnectionsAsync(new DescribeConnectionsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeConnectionsOnInterconnectResult> describeConnectionsOnInterconnectAsync(DescribeConnectionsOnInterconnectRequest request) {
        return this.describeConnectionsOnInterconnectAsync(request, null);
    }

    @Override
    public Future<DescribeConnectionsOnInterconnectResult> describeConnectionsOnInterconnectAsync(final DescribeConnectionsOnInterconnectRequest request, final AsyncHandler<DescribeConnectionsOnInterconnectRequest, DescribeConnectionsOnInterconnectResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeConnectionsOnInterconnectResult>(){

            @Override
            public DescribeConnectionsOnInterconnectResult call() throws Exception {
                DescribeConnectionsOnInterconnectResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeConnectionsOnInterconnect(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInterconnectLoaResult> describeInterconnectLoaAsync(DescribeInterconnectLoaRequest request) {
        return this.describeInterconnectLoaAsync(request, null);
    }

    @Override
    public Future<DescribeInterconnectLoaResult> describeInterconnectLoaAsync(final DescribeInterconnectLoaRequest request, final AsyncHandler<DescribeInterconnectLoaRequest, DescribeInterconnectLoaResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeInterconnectLoaResult>(){

            @Override
            public DescribeInterconnectLoaResult call() throws Exception {
                DescribeInterconnectLoaResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeInterconnectLoa(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInterconnectsResult> describeInterconnectsAsync(DescribeInterconnectsRequest request) {
        return this.describeInterconnectsAsync(request, null);
    }

    @Override
    public Future<DescribeInterconnectsResult> describeInterconnectsAsync(final DescribeInterconnectsRequest request, final AsyncHandler<DescribeInterconnectsRequest, DescribeInterconnectsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeInterconnectsResult>(){

            @Override
            public DescribeInterconnectsResult call() throws Exception {
                DescribeInterconnectsResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeInterconnects(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeInterconnectsResult> describeInterconnectsAsync() {
        return this.describeInterconnectsAsync(new DescribeInterconnectsRequest());
    }

    @Override
    public Future<DescribeInterconnectsResult> describeInterconnectsAsync(AsyncHandler<DescribeInterconnectsRequest, DescribeInterconnectsResult> asyncHandler) {
        return this.describeInterconnectsAsync(new DescribeInterconnectsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeLocationsResult> describeLocationsAsync(DescribeLocationsRequest request) {
        return this.describeLocationsAsync(request, null);
    }

    @Override
    public Future<DescribeLocationsResult> describeLocationsAsync(final DescribeLocationsRequest request, final AsyncHandler<DescribeLocationsRequest, DescribeLocationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeLocationsResult>(){

            @Override
            public DescribeLocationsResult call() throws Exception {
                DescribeLocationsResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeLocations(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeLocationsResult> describeLocationsAsync() {
        return this.describeLocationsAsync(new DescribeLocationsRequest());
    }

    @Override
    public Future<DescribeLocationsResult> describeLocationsAsync(AsyncHandler<DescribeLocationsRequest, DescribeLocationsResult> asyncHandler) {
        return this.describeLocationsAsync(new DescribeLocationsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(DescribeTagsRequest request) {
        return this.describeTagsAsync(request, null);
    }

    @Override
    public Future<DescribeTagsResult> describeTagsAsync(final DescribeTagsRequest request, final AsyncHandler<DescribeTagsRequest, DescribeTagsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeTagsResult>(){

            @Override
            public DescribeTagsResult call() throws Exception {
                DescribeTagsResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeTags(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualGatewaysResult> describeVirtualGatewaysAsync(DescribeVirtualGatewaysRequest request) {
        return this.describeVirtualGatewaysAsync(request, null);
    }

    @Override
    public Future<DescribeVirtualGatewaysResult> describeVirtualGatewaysAsync(final DescribeVirtualGatewaysRequest request, final AsyncHandler<DescribeVirtualGatewaysRequest, DescribeVirtualGatewaysResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeVirtualGatewaysResult>(){

            @Override
            public DescribeVirtualGatewaysResult call() throws Exception {
                DescribeVirtualGatewaysResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeVirtualGateways(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualGatewaysResult> describeVirtualGatewaysAsync() {
        return this.describeVirtualGatewaysAsync(new DescribeVirtualGatewaysRequest());
    }

    @Override
    public Future<DescribeVirtualGatewaysResult> describeVirtualGatewaysAsync(AsyncHandler<DescribeVirtualGatewaysRequest, DescribeVirtualGatewaysResult> asyncHandler) {
        return this.describeVirtualGatewaysAsync(new DescribeVirtualGatewaysRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeVirtualInterfacesResult> describeVirtualInterfacesAsync(DescribeVirtualInterfacesRequest request) {
        return this.describeVirtualInterfacesAsync(request, null);
    }

    @Override
    public Future<DescribeVirtualInterfacesResult> describeVirtualInterfacesAsync(final DescribeVirtualInterfacesRequest request, final AsyncHandler<DescribeVirtualInterfacesRequest, DescribeVirtualInterfacesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeVirtualInterfacesResult>(){

            @Override
            public DescribeVirtualInterfacesResult call() throws Exception {
                DescribeVirtualInterfacesResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.describeVirtualInterfaces(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVirtualInterfacesResult> describeVirtualInterfacesAsync() {
        return this.describeVirtualInterfacesAsync(new DescribeVirtualInterfacesRequest());
    }

    @Override
    public Future<DescribeVirtualInterfacesResult> describeVirtualInterfacesAsync(AsyncHandler<DescribeVirtualInterfacesRequest, DescribeVirtualInterfacesResult> asyncHandler) {
        return this.describeVirtualInterfacesAsync(new DescribeVirtualInterfacesRequest(), asyncHandler);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(final TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.tagResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(final UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result;
                try {
                    result = AmazonDirectConnectAsyncClient.this.untagResource(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

