/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.VerifyUserAttributeRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class VerifyUserAttributeRequestMarshaller
implements Marshaller<Request<VerifyUserAttributeRequest>, VerifyUserAttributeRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public VerifyUserAttributeRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<VerifyUserAttributeRequest> marshall(VerifyUserAttributeRequest verifyUserAttributeRequest) {
        if (verifyUserAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<VerifyUserAttributeRequest> request = new DefaultRequest<VerifyUserAttributeRequest>(verifyUserAttributeRequest, "AWSCognitoIdentityProvider");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityProviderService.VerifyUserAttribute");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (verifyUserAttributeRequest.getAccessToken() != null) {
                jsonGenerator.writeFieldName("AccessToken").writeValue(verifyUserAttributeRequest.getAccessToken());
            }
            if (verifyUserAttributeRequest.getAttributeName() != null) {
                jsonGenerator.writeFieldName("AttributeName").writeValue(verifyUserAttributeRequest.getAttributeName());
            }
            if (verifyUserAttributeRequest.getCode() != null) {
                jsonGenerator.writeFieldName("Code").writeValue(verifyUserAttributeRequest.getCode());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

