/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.DetachFromIndexRequest;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DetachFromIndexRequestMarshaller
implements Marshaller<Request<DetachFromIndexRequest>, DetachFromIndexRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DetachFromIndexRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DetachFromIndexRequest> marshall(DetachFromIndexRequest detachFromIndexRequest) {
        if (detachFromIndexRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DetachFromIndexRequest> request = new DefaultRequest<DetachFromIndexRequest>(detachFromIndexRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (detachFromIndexRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(detachFromIndexRequest.getDirectoryArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/index/detach";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (detachFromIndexRequest.getIndexReference() != null) {
                jsonGenerator.writeFieldName("IndexReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(detachFromIndexRequest.getIndexReference(), jsonGenerator);
            }
            if (detachFromIndexRequest.getTargetReference() != null) {
                jsonGenerator.writeFieldName("TargetReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(detachFromIndexRequest.getTargetReference(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

