/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.ContainerProperties;
import com.amazonaws.services.batch.model.KeyValuePair;
import com.amazonaws.services.batch.model.MountPoint;
import com.amazonaws.services.batch.model.Ulimit;
import com.amazonaws.services.batch.model.Volume;
import com.amazonaws.services.batch.model.transform.KeyValuePairJsonMarshaller;
import com.amazonaws.services.batch.model.transform.MountPointJsonMarshaller;
import com.amazonaws.services.batch.model.transform.UlimitJsonMarshaller;
import com.amazonaws.services.batch.model.transform.VolumeJsonMarshaller;
import java.util.List;

public class ContainerPropertiesJsonMarshaller {
    private static ContainerPropertiesJsonMarshaller instance;

    public void marshall(ContainerProperties containerProperties, StructuredJsonGenerator jsonGenerator) {
        if (containerProperties == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<Ulimit> list;
            List<MountPoint> list2;
            List<KeyValuePair> list3;
            List<Volume> volumesList;
            List<String> commandList;
            jsonGenerator.writeStartObject();
            if (containerProperties.getImage() != null) {
                jsonGenerator.writeFieldName("image").writeValue(containerProperties.getImage());
            }
            if (containerProperties.getVcpus() != null) {
                jsonGenerator.writeFieldName("vcpus").writeValue(containerProperties.getVcpus());
            }
            if (containerProperties.getMemory() != null) {
                jsonGenerator.writeFieldName("memory").writeValue(containerProperties.getMemory());
            }
            if ((commandList = containerProperties.getCommand()) != null) {
                jsonGenerator.writeFieldName("command");
                jsonGenerator.writeStartArray();
                for (String string : commandList) {
                    if (string == null) continue;
                    jsonGenerator.writeValue(string);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerProperties.getJobRoleArn() != null) {
                jsonGenerator.writeFieldName("jobRoleArn").writeValue(containerProperties.getJobRoleArn());
            }
            if ((volumesList = containerProperties.getVolumes()) != null) {
                jsonGenerator.writeFieldName("volumes");
                jsonGenerator.writeStartArray();
                for (Volume volume : volumesList) {
                    if (volume == null) continue;
                    VolumeJsonMarshaller.getInstance().marshall(volume, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list3 = containerProperties.getEnvironment()) != null) {
                jsonGenerator.writeFieldName("environment");
                jsonGenerator.writeStartArray();
                for (KeyValuePair keyValuePair : list3) {
                    if (keyValuePair == null) continue;
                    KeyValuePairJsonMarshaller.getInstance().marshall(keyValuePair, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list2 = containerProperties.getMountPoints()) != null) {
                jsonGenerator.writeFieldName("mountPoints");
                jsonGenerator.writeStartArray();
                for (MountPoint mountPointsListValue : list2) {
                    if (mountPointsListValue == null) continue;
                    MountPointJsonMarshaller.getInstance().marshall(mountPointsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerProperties.getReadonlyRootFilesystem() != null) {
                jsonGenerator.writeFieldName("readonlyRootFilesystem").writeValue(containerProperties.getReadonlyRootFilesystem());
            }
            if (containerProperties.getPrivileged() != null) {
                jsonGenerator.writeFieldName("privileged").writeValue(containerProperties.getPrivileged());
            }
            if ((list = containerProperties.getUlimits()) != null) {
                jsonGenerator.writeFieldName("ulimits");
                jsonGenerator.writeStartArray();
                for (Ulimit ulimitsListValue : list) {
                    if (ulimitsListValue == null) continue;
                    UlimitJsonMarshaller.getInstance().marshall(ulimitsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerProperties.getUser() != null) {
                jsonGenerator.writeFieldName("user").writeValue(containerProperties.getUser());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerPropertiesJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerPropertiesJsonMarshaller();
        }
        return instance;
    }
}

