/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.appstream.AmazonAppStream;
import com.amazonaws.services.appstream.model.DescribeFleetsRequest;
import com.amazonaws.services.appstream.model.DescribeFleetsResult;
import com.amazonaws.services.appstream.waiters.DescribeFleetsFunction;
import com.amazonaws.services.appstream.waiters.FleetStarted;
import com.amazonaws.services.appstream.waiters.FleetStopped;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonAppStreamWaiters {
    private final AmazonAppStream client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonAppStreamWaiters(AmazonAppStream client) {
        this.client = client;
    }

    public Waiter<DescribeFleetsRequest> fleetStarted() {
        return new WaiterBuilder<DescribeFleetsRequest, DescribeFleetsResult>().withSdkFunction(new DescribeFleetsFunction(this.client)).withAcceptors(new FleetStarted.IsACTIVEMatcher(), new FleetStarted.IsPENDING_DEACTIVATEMatcher(), new FleetStarted.IsINACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeFleetsRequest> fleetStopped() {
        return new WaiterBuilder<DescribeFleetsRequest, DescribeFleetsResult>().withSdkFunction(new DescribeFleetsFunction(this.client)).withAcceptors(new FleetStopped.IsINACTIVEMatcher(), new FleetStopped.IsPENDING_ACTIVATEMatcher(), new FleetStopped.IsACTIVEMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }
}

