/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.appstream.model.DescribeSessionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeSessionsRequestMarshaller
implements Marshaller<Request<DescribeSessionsRequest>, DescribeSessionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeSessionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeSessionsRequest> marshall(DescribeSessionsRequest describeSessionsRequest) {
        if (describeSessionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeSessionsRequest> request = new DefaultRequest<DescribeSessionsRequest>(describeSessionsRequest, "AmazonAppStream");
        request.addHeader("X-Amz-Target", "PhotonAdminProxyService.DescribeSessions");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeSessionsRequest.getStackName() != null) {
                jsonGenerator.writeFieldName("StackName").writeValue(describeSessionsRequest.getStackName());
            }
            if (describeSessionsRequest.getFleetName() != null) {
                jsonGenerator.writeFieldName("FleetName").writeValue(describeSessionsRequest.getFleetName());
            }
            if (describeSessionsRequest.getUserId() != null) {
                jsonGenerator.writeFieldName("UserId").writeValue(describeSessionsRequest.getUserId());
            }
            if (describeSessionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(describeSessionsRequest.getNextToken());
            }
            if (describeSessionsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeSessionsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

