/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.applicationdiscovery.model.DisassociateConfigurationItemsFromApplicationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DisassociateConfigurationItemsFromApplicationRequestMarshaller
implements Marshaller<Request<DisassociateConfigurationItemsFromApplicationRequest>, DisassociateConfigurationItemsFromApplicationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DisassociateConfigurationItemsFromApplicationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DisassociateConfigurationItemsFromApplicationRequest> marshall(DisassociateConfigurationItemsFromApplicationRequest disassociateConfigurationItemsFromApplicationRequest) {
        if (disassociateConfigurationItemsFromApplicationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DisassociateConfigurationItemsFromApplicationRequest> request = new DefaultRequest<DisassociateConfigurationItemsFromApplicationRequest>(disassociateConfigurationItemsFromApplicationRequest, "AWSApplicationDiscovery");
        request.addHeader("X-Amz-Target", "AWSPoseidonService_V2015_11_01.DisassociateConfigurationItemsFromApplication");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<String> configurationIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (disassociateConfigurationItemsFromApplicationRequest.getApplicationConfigurationId() != null) {
                jsonGenerator.writeFieldName("applicationConfigurationId").writeValue(disassociateConfigurationItemsFromApplicationRequest.getApplicationConfigurationId());
            }
            if ((configurationIdsList = disassociateConfigurationItemsFromApplicationRequest.getConfigurationIds()) != null) {
                jsonGenerator.writeFieldName("configurationIds");
                jsonGenerator.writeStartArray();
                for (String configurationIdsListValue : configurationIdsList) {
                    if (configurationIdsListValue == null) continue;
                    jsonGenerator.writeValue(configurationIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

