/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dax.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.dax.model.Node;
import java.util.Date;

@SdkInternalApi
public class NodeMarshaller {
    private static final MarshallingInfo<String> NODEID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeId").build();
    private static final MarshallingInfo<StructuredPojo> ENDPOINT_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Endpoint").build();
    private static final MarshallingInfo<Date> NODECREATETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeCreateTime").build();
    private static final MarshallingInfo<String> AVAILABILITYZONE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AvailabilityZone").build();
    private static final MarshallingInfo<String> NODESTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NodeStatus").build();
    private static final MarshallingInfo<String> PARAMETERGROUPSTATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupStatus").build();
    private static final NodeMarshaller instance = new NodeMarshaller();

    public static NodeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Node node, ProtocolMarshaller protocolMarshaller) {
        if (node == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(node.getNodeId(), NODEID_BINDING);
            protocolMarshaller.marshall(node.getEndpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall(node.getNodeCreateTime(), NODECREATETIME_BINDING);
            protocolMarshaller.marshall(node.getAvailabilityZone(), AVAILABILITYZONE_BINDING);
            protocolMarshaller.marshall(node.getNodeStatus(), NODESTATUS_BINDING);
            protocolMarshaller.marshall(node.getParameterGroupStatus(), PARAMETERGROUPSTATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

