/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.devicefarm.model.TrialMinutes;
import com.amazonaws.services.devicefarm.model.transform.AccountSettingsMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AccountSettings
implements Serializable,
Cloneable,
StructuredPojo {
    private String awsAccountNumber;
    private Map<String, Integer> unmeteredDevices;
    private Map<String, Integer> unmeteredRemoteAccessDevices;
    private Integer maxJobTimeoutMinutes;
    private TrialMinutes trialMinutes;
    private Map<String, Integer> maxSlots;
    private Integer defaultJobTimeoutMinutes;

    public void setAwsAccountNumber(String awsAccountNumber) {
        this.awsAccountNumber = awsAccountNumber;
    }

    public String getAwsAccountNumber() {
        return this.awsAccountNumber;
    }

    public AccountSettings withAwsAccountNumber(String awsAccountNumber) {
        this.setAwsAccountNumber(awsAccountNumber);
        return this;
    }

    public Map<String, Integer> getUnmeteredDevices() {
        return this.unmeteredDevices;
    }

    public void setUnmeteredDevices(Map<String, Integer> unmeteredDevices) {
        this.unmeteredDevices = unmeteredDevices;
    }

    public AccountSettings withUnmeteredDevices(Map<String, Integer> unmeteredDevices) {
        this.setUnmeteredDevices(unmeteredDevices);
        return this;
    }

    public AccountSettings addUnmeteredDevicesEntry(String key, Integer value) {
        if (null == this.unmeteredDevices) {
            this.unmeteredDevices = new HashMap<String, Integer>();
        }
        if (this.unmeteredDevices.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.unmeteredDevices.put(key, value);
        return this;
    }

    public AccountSettings clearUnmeteredDevicesEntries() {
        this.unmeteredDevices = null;
        return this;
    }

    public Map<String, Integer> getUnmeteredRemoteAccessDevices() {
        return this.unmeteredRemoteAccessDevices;
    }

    public void setUnmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
        this.unmeteredRemoteAccessDevices = unmeteredRemoteAccessDevices;
    }

    public AccountSettings withUnmeteredRemoteAccessDevices(Map<String, Integer> unmeteredRemoteAccessDevices) {
        this.setUnmeteredRemoteAccessDevices(unmeteredRemoteAccessDevices);
        return this;
    }

    public AccountSettings addUnmeteredRemoteAccessDevicesEntry(String key, Integer value) {
        if (null == this.unmeteredRemoteAccessDevices) {
            this.unmeteredRemoteAccessDevices = new HashMap<String, Integer>();
        }
        if (this.unmeteredRemoteAccessDevices.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.unmeteredRemoteAccessDevices.put(key, value);
        return this;
    }

    public AccountSettings clearUnmeteredRemoteAccessDevicesEntries() {
        this.unmeteredRemoteAccessDevices = null;
        return this;
    }

    public void setMaxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
        this.maxJobTimeoutMinutes = maxJobTimeoutMinutes;
    }

    public Integer getMaxJobTimeoutMinutes() {
        return this.maxJobTimeoutMinutes;
    }

    public AccountSettings withMaxJobTimeoutMinutes(Integer maxJobTimeoutMinutes) {
        this.setMaxJobTimeoutMinutes(maxJobTimeoutMinutes);
        return this;
    }

    public void setTrialMinutes(TrialMinutes trialMinutes) {
        this.trialMinutes = trialMinutes;
    }

    public TrialMinutes getTrialMinutes() {
        return this.trialMinutes;
    }

    public AccountSettings withTrialMinutes(TrialMinutes trialMinutes) {
        this.setTrialMinutes(trialMinutes);
        return this;
    }

    public Map<String, Integer> getMaxSlots() {
        return this.maxSlots;
    }

    public void setMaxSlots(Map<String, Integer> maxSlots) {
        this.maxSlots = maxSlots;
    }

    public AccountSettings withMaxSlots(Map<String, Integer> maxSlots) {
        this.setMaxSlots(maxSlots);
        return this;
    }

    public AccountSettings addMaxSlotsEntry(String key, Integer value) {
        if (null == this.maxSlots) {
            this.maxSlots = new HashMap<String, Integer>();
        }
        if (this.maxSlots.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.maxSlots.put(key, value);
        return this;
    }

    public AccountSettings clearMaxSlotsEntries() {
        this.maxSlots = null;
        return this;
    }

    public void setDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
        this.defaultJobTimeoutMinutes = defaultJobTimeoutMinutes;
    }

    public Integer getDefaultJobTimeoutMinutes() {
        return this.defaultJobTimeoutMinutes;
    }

    public AccountSettings withDefaultJobTimeoutMinutes(Integer defaultJobTimeoutMinutes) {
        this.setDefaultJobTimeoutMinutes(defaultJobTimeoutMinutes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountNumber() != null) {
            sb.append("AwsAccountNumber: ").append(this.getAwsAccountNumber()).append(",");
        }
        if (this.getUnmeteredDevices() != null) {
            sb.append("UnmeteredDevices: ").append(this.getUnmeteredDevices()).append(",");
        }
        if (this.getUnmeteredRemoteAccessDevices() != null) {
            sb.append("UnmeteredRemoteAccessDevices: ").append(this.getUnmeteredRemoteAccessDevices()).append(",");
        }
        if (this.getMaxJobTimeoutMinutes() != null) {
            sb.append("MaxJobTimeoutMinutes: ").append(this.getMaxJobTimeoutMinutes()).append(",");
        }
        if (this.getTrialMinutes() != null) {
            sb.append("TrialMinutes: ").append(this.getTrialMinutes()).append(",");
        }
        if (this.getMaxSlots() != null) {
            sb.append("MaxSlots: ").append(this.getMaxSlots()).append(",");
        }
        if (this.getDefaultJobTimeoutMinutes() != null) {
            sb.append("DefaultJobTimeoutMinutes: ").append(this.getDefaultJobTimeoutMinutes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings)obj;
        if (other.getAwsAccountNumber() == null ^ this.getAwsAccountNumber() == null) {
            return false;
        }
        if (other.getAwsAccountNumber() != null && !other.getAwsAccountNumber().equals(this.getAwsAccountNumber())) {
            return false;
        }
        if (other.getUnmeteredDevices() == null ^ this.getUnmeteredDevices() == null) {
            return false;
        }
        if (other.getUnmeteredDevices() != null && !other.getUnmeteredDevices().equals(this.getUnmeteredDevices())) {
            return false;
        }
        if (other.getUnmeteredRemoteAccessDevices() == null ^ this.getUnmeteredRemoteAccessDevices() == null) {
            return false;
        }
        if (other.getUnmeteredRemoteAccessDevices() != null && !other.getUnmeteredRemoteAccessDevices().equals(this.getUnmeteredRemoteAccessDevices())) {
            return false;
        }
        if (other.getMaxJobTimeoutMinutes() == null ^ this.getMaxJobTimeoutMinutes() == null) {
            return false;
        }
        if (other.getMaxJobTimeoutMinutes() != null && !other.getMaxJobTimeoutMinutes().equals(this.getMaxJobTimeoutMinutes())) {
            return false;
        }
        if (other.getTrialMinutes() == null ^ this.getTrialMinutes() == null) {
            return false;
        }
        if (other.getTrialMinutes() != null && !other.getTrialMinutes().equals(this.getTrialMinutes())) {
            return false;
        }
        if (other.getMaxSlots() == null ^ this.getMaxSlots() == null) {
            return false;
        }
        if (other.getMaxSlots() != null && !other.getMaxSlots().equals(this.getMaxSlots())) {
            return false;
        }
        if (other.getDefaultJobTimeoutMinutes() == null ^ this.getDefaultJobTimeoutMinutes() == null) {
            return false;
        }
        return other.getDefaultJobTimeoutMinutes() == null || other.getDefaultJobTimeoutMinutes().equals(this.getDefaultJobTimeoutMinutes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountNumber() == null ? 0 : this.getAwsAccountNumber().hashCode());
        hashCode = 31 * hashCode + (this.getUnmeteredDevices() == null ? 0 : this.getUnmeteredDevices().hashCode());
        hashCode = 31 * hashCode + (this.getUnmeteredRemoteAccessDevices() == null ? 0 : this.getUnmeteredRemoteAccessDevices().hashCode());
        hashCode = 31 * hashCode + (this.getMaxJobTimeoutMinutes() == null ? 0 : this.getMaxJobTimeoutMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getTrialMinutes() == null ? 0 : this.getTrialMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getMaxSlots() == null ? 0 : this.getMaxSlots().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultJobTimeoutMinutes() == null ? 0 : this.getDefaultJobTimeoutMinutes().hashCode());
        return hashCode;
    }

    public AccountSettings clone() {
        try {
            return (AccountSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

