/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.thirdparty.jackson.databind;

import com.amazonaws.thirdparty.jackson.core.JsonGenerator;
import com.amazonaws.thirdparty.jackson.core.JsonProcessingException;
import com.amazonaws.thirdparty.jackson.databind.JavaType;
import com.amazonaws.thirdparty.jackson.databind.JsonMappingException;
import com.amazonaws.thirdparty.jackson.databind.SerializerProvider;
import com.amazonaws.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.amazonaws.thirdparty.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.amazonaws.thirdparty.jackson.databind.jsontype.TypeSerializer;
import com.amazonaws.thirdparty.jackson.databind.ser.PropertyWriter;
import com.amazonaws.thirdparty.jackson.databind.util.EmptyIterator;
import com.amazonaws.thirdparty.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.Iterator;

public abstract class JsonSerializer<T>
implements JsonFormatVisitable {
    public JsonSerializer<T> unwrappingSerializer(NameTransformer unwrapper) {
        return this;
    }

    public JsonSerializer<T> replaceDelegatee(JsonSerializer<?> delegatee) {
        throw new UnsupportedOperationException();
    }

    public JsonSerializer<?> withFilterId(Object filterId) {
        return this;
    }

    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException, JsonProcessingException;

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        Class<Object> clz = this.handledType();
        if (clz == null) {
            clz = value.getClass();
        }
        throw serializers.mappingException("Type id handling not implemented for type %s (by serializer of type %s)", clz.getName(), this.getClass().getName());
    }

    public Class<T> handledType() {
        return null;
    }

    @Deprecated
    public boolean isEmpty(T value) {
        return this.isEmpty(null, value);
    }

    public boolean isEmpty(SerializerProvider provider, T value) {
        return value == null;
    }

    public boolean usesObjectId() {
        return false;
    }

    public boolean isUnwrappingSerializer() {
        return false;
    }

    public JsonSerializer<?> getDelegatee() {
        return null;
    }

    public Iterator<PropertyWriter> properties() {
        return EmptyIterator.instance();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType type) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(type);
        }
    }

    public static abstract class None
    extends JsonSerializer<Object> {
    }
}

