/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleemail.model.ListTemplatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ListTemplatesRequestMarshaller
implements Marshaller<Request<ListTemplatesRequest>, ListTemplatesRequest> {
    @Override
    public Request<ListTemplatesRequest> marshall(ListTemplatesRequest listTemplatesRequest) {
        if (listTemplatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTemplatesRequest> request = new DefaultRequest<ListTemplatesRequest>(listTemplatesRequest, "AmazonSimpleEmailService");
        request.addParameter("Action", "ListTemplates");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listTemplatesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(listTemplatesRequest.getNextToken()));
        }
        if (listTemplatesRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger(listTemplatesRequest.getMaxItems()));
        }
        return request;
    }
}

