/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.services.glue.model.S3Target;
import com.amazonaws.thirdparty.jackson.core.JsonToken;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;

public class S3TargetJsonUnmarshaller
implements Unmarshaller<S3Target, JsonUnmarshallerContext> {
    private static S3TargetJsonUnmarshaller instance;

    @Override
    public S3Target unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3Target s3Target = new S3Target();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Path", targetDepth)) {
                    context.nextToken();
                    s3Target.setPath(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Exclusions", targetDepth)) {
                    context.nextToken();
                    s3Target.setExclusions(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3Target;
    }

    public static S3TargetJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3TargetJsonUnmarshaller();
        }
        return instance;
    }
}

