/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.Tenancy;
import com.amazonaws.services.ec2.model.VpcCidrBlockAssociation;
import com.amazonaws.services.ec2.model.VpcIpv6CidrBlockAssociation;
import com.amazonaws.services.ec2.model.VpcState;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Vpc
implements Serializable,
Cloneable {
    private String cidrBlock;
    private String dhcpOptionsId;
    private String state;
    private String vpcId;
    private String instanceTenancy;
    private SdkInternalList<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet;
    private SdkInternalList<VpcCidrBlockAssociation> cidrBlockAssociationSet;
    private Boolean isDefault;
    private SdkInternalList<Tag> tags;

    public void setCidrBlock(String cidrBlock) {
        this.cidrBlock = cidrBlock;
    }

    public String getCidrBlock() {
        return this.cidrBlock;
    }

    public Vpc withCidrBlock(String cidrBlock) {
        this.setCidrBlock(cidrBlock);
        return this;
    }

    public void setDhcpOptionsId(String dhcpOptionsId) {
        this.dhcpOptionsId = dhcpOptionsId;
    }

    public String getDhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public Vpc withDhcpOptionsId(String dhcpOptionsId) {
        this.setDhcpOptionsId(dhcpOptionsId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Vpc withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(VpcState state) {
        this.withState(state);
    }

    public Vpc withState(VpcState state) {
        this.state = state.toString();
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Vpc withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setInstanceTenancy(String instanceTenancy) {
        this.instanceTenancy = instanceTenancy;
    }

    public String getInstanceTenancy() {
        return this.instanceTenancy;
    }

    public Vpc withInstanceTenancy(String instanceTenancy) {
        this.setInstanceTenancy(instanceTenancy);
        return this;
    }

    public void setInstanceTenancy(Tenancy instanceTenancy) {
        this.withInstanceTenancy(instanceTenancy);
    }

    public Vpc withInstanceTenancy(Tenancy instanceTenancy) {
        this.instanceTenancy = instanceTenancy.toString();
        return this;
    }

    public List<VpcIpv6CidrBlockAssociation> getIpv6CidrBlockAssociationSet() {
        if (this.ipv6CidrBlockAssociationSet == null) {
            this.ipv6CidrBlockAssociationSet = new SdkInternalList();
        }
        return this.ipv6CidrBlockAssociationSet;
    }

    public void setIpv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
        if (ipv6CidrBlockAssociationSet == null) {
            this.ipv6CidrBlockAssociationSet = null;
            return;
        }
        this.ipv6CidrBlockAssociationSet = new SdkInternalList<VpcIpv6CidrBlockAssociation>(ipv6CidrBlockAssociationSet);
    }

    public Vpc withIpv6CidrBlockAssociationSet(VpcIpv6CidrBlockAssociation ... ipv6CidrBlockAssociationSet) {
        if (this.ipv6CidrBlockAssociationSet == null) {
            this.setIpv6CidrBlockAssociationSet(new SdkInternalList<VpcIpv6CidrBlockAssociation>(ipv6CidrBlockAssociationSet.length));
        }
        for (VpcIpv6CidrBlockAssociation ele : ipv6CidrBlockAssociationSet) {
            this.ipv6CidrBlockAssociationSet.add(ele);
        }
        return this;
    }

    public Vpc withIpv6CidrBlockAssociationSet(Collection<VpcIpv6CidrBlockAssociation> ipv6CidrBlockAssociationSet) {
        this.setIpv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet);
        return this;
    }

    public List<VpcCidrBlockAssociation> getCidrBlockAssociationSet() {
        if (this.cidrBlockAssociationSet == null) {
            this.cidrBlockAssociationSet = new SdkInternalList();
        }
        return this.cidrBlockAssociationSet;
    }

    public void setCidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet) {
        if (cidrBlockAssociationSet == null) {
            this.cidrBlockAssociationSet = null;
            return;
        }
        this.cidrBlockAssociationSet = new SdkInternalList<VpcCidrBlockAssociation>(cidrBlockAssociationSet);
    }

    public Vpc withCidrBlockAssociationSet(VpcCidrBlockAssociation ... cidrBlockAssociationSet) {
        if (this.cidrBlockAssociationSet == null) {
            this.setCidrBlockAssociationSet(new SdkInternalList<VpcCidrBlockAssociation>(cidrBlockAssociationSet.length));
        }
        for (VpcCidrBlockAssociation ele : cidrBlockAssociationSet) {
            this.cidrBlockAssociationSet.add(ele);
        }
        return this;
    }

    public Vpc withCidrBlockAssociationSet(Collection<VpcCidrBlockAssociation> cidrBlockAssociationSet) {
        this.setCidrBlockAssociationSet(cidrBlockAssociationSet);
        return this;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Vpc withIsDefault(Boolean isDefault) {
        this.setIsDefault(isDefault);
        return this;
    }

    public Boolean isDefault() {
        return this.isDefault;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public Vpc withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Vpc withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCidrBlock() != null) {
            sb.append("CidrBlock: ").append(this.getCidrBlock()).append(",");
        }
        if (this.getDhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(this.getDhcpOptionsId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getInstanceTenancy() != null) {
            sb.append("InstanceTenancy: ").append(this.getInstanceTenancy()).append(",");
        }
        if (this.getIpv6CidrBlockAssociationSet() != null) {
            sb.append("Ipv6CidrBlockAssociationSet: ").append(this.getIpv6CidrBlockAssociationSet()).append(",");
        }
        if (this.getCidrBlockAssociationSet() != null) {
            sb.append("CidrBlockAssociationSet: ").append(this.getCidrBlockAssociationSet()).append(",");
        }
        if (this.getIsDefault() != null) {
            sb.append("IsDefault: ").append(this.getIsDefault()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Vpc)) {
            return false;
        }
        Vpc other = (Vpc)obj;
        if (other.getCidrBlock() == null ^ this.getCidrBlock() == null) {
            return false;
        }
        if (other.getCidrBlock() != null && !other.getCidrBlock().equals(this.getCidrBlock())) {
            return false;
        }
        if (other.getDhcpOptionsId() == null ^ this.getDhcpOptionsId() == null) {
            return false;
        }
        if (other.getDhcpOptionsId() != null && !other.getDhcpOptionsId().equals(this.getDhcpOptionsId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getInstanceTenancy() == null ^ this.getInstanceTenancy() == null) {
            return false;
        }
        if (other.getInstanceTenancy() != null && !other.getInstanceTenancy().equals(this.getInstanceTenancy())) {
            return false;
        }
        if (other.getIpv6CidrBlockAssociationSet() == null ^ this.getIpv6CidrBlockAssociationSet() == null) {
            return false;
        }
        if (other.getIpv6CidrBlockAssociationSet() != null && !other.getIpv6CidrBlockAssociationSet().equals(this.getIpv6CidrBlockAssociationSet())) {
            return false;
        }
        if (other.getCidrBlockAssociationSet() == null ^ this.getCidrBlockAssociationSet() == null) {
            return false;
        }
        if (other.getCidrBlockAssociationSet() != null && !other.getCidrBlockAssociationSet().equals(this.getCidrBlockAssociationSet())) {
            return false;
        }
        if (other.getIsDefault() == null ^ this.getIsDefault() == null) {
            return false;
        }
        if (other.getIsDefault() != null && !other.getIsDefault().equals(this.getIsDefault())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCidrBlock() == null ? 0 : this.getCidrBlock().hashCode());
        hashCode = 31 * hashCode + (this.getDhcpOptionsId() == null ? 0 : this.getDhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceTenancy() == null ? 0 : this.getInstanceTenancy().hashCode());
        hashCode = 31 * hashCode + (this.getIpv6CidrBlockAssociationSet() == null ? 0 : this.getIpv6CidrBlockAssociationSet().hashCode());
        hashCode = 31 * hashCode + (this.getCidrBlockAssociationSet() == null ? 0 : this.getCidrBlockAssociationSet().hashCode());
        hashCode = 31 * hashCode + (this.getIsDefault() == null ? 0 : this.getIsDefault().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public Vpc clone() {
        try {
            return (Vpc)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

