/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appstream.model.FleetErrorCode;
import com.amazonaws.services.appstream.model.transform.ResourceErrorMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

public class ResourceError
implements Serializable,
Cloneable,
StructuredPojo {
    private String errorCode;
    private String errorMessage;
    private Date errorTimestamp;

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public ResourceError withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public ResourceError withErrorCode(FleetErrorCode errorCode) {
        this.errorCode = errorCode.toString();
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public ResourceError withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public void setErrorTimestamp(Date errorTimestamp) {
        this.errorTimestamp = errorTimestamp;
    }

    public Date getErrorTimestamp() {
        return this.errorTimestamp;
    }

    public ResourceError withErrorTimestamp(Date errorTimestamp) {
        this.setErrorTimestamp(errorTimestamp);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage()).append(",");
        }
        if (this.getErrorTimestamp() != null) {
            sb.append("ErrorTimestamp: ").append(this.getErrorTimestamp());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceError)) {
            return false;
        }
        ResourceError other = (ResourceError)obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getErrorTimestamp() == null ^ this.getErrorTimestamp() == null) {
            return false;
        }
        return other.getErrorTimestamp() == null || other.getErrorTimestamp().equals(this.getErrorTimestamp());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getErrorTimestamp() == null ? 0 : this.getErrorTimestamp().hashCode());
        return hashCode;
    }

    public ResourceError clone() {
        try {
            return (ResourceError)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceErrorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

