/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.CannedAccessControlList;
import com.amazonaws.services.iot.model.transform.S3ActionMarshaller;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class S3Action
implements Serializable,
Cloneable,
StructuredPojo {
    private String roleArn;
    private String bucketName;
    private String key;
    private String cannedAcl;

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public S3Action withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3Action withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public S3Action withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setCannedAcl(String cannedAcl) {
        this.cannedAcl = cannedAcl;
    }

    @JsonProperty(value="cannedAcl")
    public String getCannedAcl() {
        return this.cannedAcl;
    }

    public S3Action withCannedAcl(String cannedAcl) {
        this.setCannedAcl(cannedAcl);
        return this;
    }

    @JsonIgnore
    public void setCannedAcl(CannedAccessControlList cannedAcl) {
        this.withCannedAcl(cannedAcl);
    }

    public S3Action withCannedAcl(CannedAccessControlList cannedAcl) {
        this.cannedAcl = cannedAcl.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getCannedAcl() != null) {
            sb.append("CannedAcl: ").append(this.getCannedAcl());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action)obj;
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getCannedAcl() == null ^ this.getCannedAcl() == null) {
            return false;
        }
        return other.getCannedAcl() == null || other.getCannedAcl().equals(this.getCannedAcl());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getCannedAcl() == null ? 0 : this.getCannedAcl().hashCode());
        return hashCode;
    }

    public S3Action clone() {
        try {
            return (S3Action)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

