/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImportSnapshotRequest;
import com.amazonaws.services.ec2.model.SnapshotDiskContainer;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportSnapshotRequestMarshaller
implements Marshaller<Request<ImportSnapshotRequest>, ImportSnapshotRequest> {
    @Override
    public Request<ImportSnapshotRequest> marshall(ImportSnapshotRequest importSnapshotRequest) {
        SnapshotDiskContainer diskContainer;
        if (importSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ImportSnapshotRequest> request = new DefaultRequest<ImportSnapshotRequest>(importSnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "ImportSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        ClientData clientData = importSnapshotRequest.getClientData();
        if (clientData != null) {
            if (clientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString(clientData.getComment()));
            }
            if (clientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate(clientData.getUploadEnd()));
            }
            if (clientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble(clientData.getUploadSize()));
            }
            if (clientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate(clientData.getUploadStart()));
            }
        }
        if (importSnapshotRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(importSnapshotRequest.getClientToken()));
        }
        if (importSnapshotRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(importSnapshotRequest.getDescription()));
        }
        if ((diskContainer = importSnapshotRequest.getDiskContainer()) != null) {
            UserBucket userBucket;
            if (diskContainer.getDescription() != null) {
                request.addParameter("DiskContainer.Description", StringUtils.fromString(diskContainer.getDescription()));
            }
            if (diskContainer.getFormat() != null) {
                request.addParameter("DiskContainer.Format", StringUtils.fromString(diskContainer.getFormat()));
            }
            if (diskContainer.getUrl() != null) {
                request.addParameter("DiskContainer.Url", StringUtils.fromString(diskContainer.getUrl()));
            }
            if ((userBucket = diskContainer.getUserBucket()) != null) {
                if (userBucket.getS3Bucket() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Bucket", StringUtils.fromString(userBucket.getS3Bucket()));
                }
                if (userBucket.getS3Key() != null) {
                    request.addParameter("DiskContainer.UserBucket.S3Key", StringUtils.fromString(userBucket.getS3Key()));
                }
            }
        }
        if (importSnapshotRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString(importSnapshotRequest.getRoleName()));
        }
        return request;
    }
}

