/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.transform.UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateSecurityGroupRuleDescriptionsEgressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<UpdateSecurityGroupRuleDescriptionsEgressRequest> {
    private String groupId;
    private String groupName;
    private SdkInternalList<IpPermission> ipPermissions;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public List<IpPermission> getIpPermissions() {
        if (this.ipPermissions == null) {
            this.ipPermissions = new SdkInternalList();
        }
        return this.ipPermissions;
    }

    public void setIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
            return;
        }
        this.ipPermissions = new SdkInternalList<IpPermission>(ipPermissions);
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withIpPermissions(IpPermission ... ipPermissions) {
        if (this.ipPermissions == null) {
            this.setIpPermissions(new SdkInternalList<IpPermission>(ipPermissions.length));
        }
        for (IpPermission ele : ipPermissions) {
            this.ipPermissions.add(ele);
        }
        return this;
    }

    public UpdateSecurityGroupRuleDescriptionsEgressRequest withIpPermissions(Collection<IpPermission> ipPermissions) {
        this.setIpPermissions(ipPermissions);
        return this;
    }

    @Override
    public Request<UpdateSecurityGroupRuleDescriptionsEgressRequest> getDryRunRequest() {
        Request<UpdateSecurityGroupRuleDescriptionsEgressRequest> request = new UpdateSecurityGroupRuleDescriptionsEgressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getIpPermissions() != null) {
            sb.append("IpPermissions: ").append(this.getIpPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityGroupRuleDescriptionsEgressRequest)) {
            return false;
        }
        UpdateSecurityGroupRuleDescriptionsEgressRequest other = (UpdateSecurityGroupRuleDescriptionsEgressRequest)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getIpPermissions() == null ^ this.getIpPermissions() == null) {
            return false;
        }
        return other.getIpPermissions() == null || other.getIpPermissions().equals(this.getIpPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissions() == null ? 0 : this.getIpPermissions().hashCode());
        return hashCode;
    }

    @Override
    public UpdateSecurityGroupRuleDescriptionsEgressRequest clone() {
        return (UpdateSecurityGroupRuleDescriptionsEgressRequest)super.clone();
    }
}

