/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticloadbalancingv2.model.Action;
import com.amazonaws.services.elasticloadbalancingv2.model.Certificate;
import com.amazonaws.services.elasticloadbalancingv2.model.ProtocolEnum;
import com.amazonaws.thirdparty.jackson.annotation.JsonIgnore;
import com.amazonaws.thirdparty.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyListenerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String listenerArn;
    private Integer port;
    private String protocol;
    private String sslPolicy;
    private List<Certificate> certificates;
    private List<Action> defaultActions;

    public void setListenerArn(String listenerArn) {
        this.listenerArn = listenerArn;
    }

    public String getListenerArn() {
        return this.listenerArn;
    }

    public ModifyListenerRequest withListenerArn(String listenerArn) {
        this.setListenerArn(listenerArn);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public ModifyListenerRequest withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty(value="protocol")
    public String getProtocol() {
        return this.protocol;
    }

    public ModifyListenerRequest withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    @JsonIgnore
    public void setProtocol(ProtocolEnum protocol) {
        this.withProtocol(protocol);
    }

    public ModifyListenerRequest withProtocol(ProtocolEnum protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setSslPolicy(String sslPolicy) {
        this.sslPolicy = sslPolicy;
    }

    public String getSslPolicy() {
        return this.sslPolicy;
    }

    public ModifyListenerRequest withSslPolicy(String sslPolicy) {
        this.setSslPolicy(sslPolicy);
        return this;
    }

    public List<Certificate> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Collection<Certificate> certificates) {
        if (certificates == null) {
            this.certificates = null;
            return;
        }
        this.certificates = new ArrayList<Certificate>(certificates);
    }

    public ModifyListenerRequest withCertificates(Certificate ... certificates) {
        if (this.certificates == null) {
            this.setCertificates(new ArrayList<Certificate>(certificates.length));
        }
        for (Certificate ele : certificates) {
            this.certificates.add(ele);
        }
        return this;
    }

    public ModifyListenerRequest withCertificates(Collection<Certificate> certificates) {
        this.setCertificates(certificates);
        return this;
    }

    public List<Action> getDefaultActions() {
        return this.defaultActions;
    }

    public void setDefaultActions(Collection<Action> defaultActions) {
        if (defaultActions == null) {
            this.defaultActions = null;
            return;
        }
        this.defaultActions = new ArrayList<Action>(defaultActions);
    }

    public ModifyListenerRequest withDefaultActions(Action ... defaultActions) {
        if (this.defaultActions == null) {
            this.setDefaultActions(new ArrayList<Action>(defaultActions.length));
        }
        for (Action ele : defaultActions) {
            this.defaultActions.add(ele);
        }
        return this;
    }

    public ModifyListenerRequest withDefaultActions(Collection<Action> defaultActions) {
        this.setDefaultActions(defaultActions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getListenerArn() != null) {
            sb.append("ListenerArn: ").append(this.getListenerArn()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getSslPolicy() != null) {
            sb.append("SslPolicy: ").append(this.getSslPolicy()).append(",");
        }
        if (this.getCertificates() != null) {
            sb.append("Certificates: ").append(this.getCertificates()).append(",");
        }
        if (this.getDefaultActions() != null) {
            sb.append("DefaultActions: ").append(this.getDefaultActions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyListenerRequest)) {
            return false;
        }
        ModifyListenerRequest other = (ModifyListenerRequest)obj;
        if (other.getListenerArn() == null ^ this.getListenerArn() == null) {
            return false;
        }
        if (other.getListenerArn() != null && !other.getListenerArn().equals(this.getListenerArn())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getSslPolicy() == null ^ this.getSslPolicy() == null) {
            return false;
        }
        if (other.getSslPolicy() != null && !other.getSslPolicy().equals(this.getSslPolicy())) {
            return false;
        }
        if (other.getCertificates() == null ^ this.getCertificates() == null) {
            return false;
        }
        if (other.getCertificates() != null && !other.getCertificates().equals(this.getCertificates())) {
            return false;
        }
        if (other.getDefaultActions() == null ^ this.getDefaultActions() == null) {
            return false;
        }
        return other.getDefaultActions() == null || other.getDefaultActions().equals(this.getDefaultActions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getListenerArn() == null ? 0 : this.getListenerArn().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getSslPolicy() == null ? 0 : this.getSslPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getCertificates() == null ? 0 : this.getCertificates().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultActions() == null ? 0 : this.getDefaultActions().hashCode());
        return hashCode;
    }

    @Override
    public ModifyListenerRequest clone() {
        return (ModifyListenerRequest)super.clone();
    }
}

