/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.AgentUpdateStatus;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.Resource;
import com.amazonaws.services.ecs.model.VersionInfo;
import com.amazonaws.services.ecs.model.transform.ContainerInstanceMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ContainerInstance
implements Serializable,
Cloneable,
StructuredPojo {
    private String containerInstanceArn;
    private String ec2InstanceId;
    private Long version;
    private VersionInfo versionInfo;
    private SdkInternalList<Resource> remainingResources;
    private SdkInternalList<Resource> registeredResources;
    private String status;
    private Boolean agentConnected;
    private Integer runningTasksCount;
    private Integer pendingTasksCount;
    private String agentUpdateStatus;
    private SdkInternalList<Attribute> attributes;
    private Date registeredAt;

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    public ContainerInstance withContainerInstanceArn(String containerInstanceArn) {
        this.setContainerInstanceArn(containerInstanceArn);
        return this;
    }

    public void setEc2InstanceId(String ec2InstanceId) {
        this.ec2InstanceId = ec2InstanceId;
    }

    public String getEc2InstanceId() {
        return this.ec2InstanceId;
    }

    public ContainerInstance withEc2InstanceId(String ec2InstanceId) {
        this.setEc2InstanceId(ec2InstanceId);
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public ContainerInstance withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public void setVersionInfo(VersionInfo versionInfo) {
        this.versionInfo = versionInfo;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public ContainerInstance withVersionInfo(VersionInfo versionInfo) {
        this.setVersionInfo(versionInfo);
        return this;
    }

    public List<Resource> getRemainingResources() {
        if (this.remainingResources == null) {
            this.remainingResources = new SdkInternalList();
        }
        return this.remainingResources;
    }

    public void setRemainingResources(Collection<Resource> remainingResources) {
        if (remainingResources == null) {
            this.remainingResources = null;
            return;
        }
        this.remainingResources = new SdkInternalList<Resource>(remainingResources);
    }

    public ContainerInstance withRemainingResources(Resource ... remainingResources) {
        if (this.remainingResources == null) {
            this.setRemainingResources(new SdkInternalList<Resource>(remainingResources.length));
        }
        for (Resource ele : remainingResources) {
            this.remainingResources.add(ele);
        }
        return this;
    }

    public ContainerInstance withRemainingResources(Collection<Resource> remainingResources) {
        this.setRemainingResources(remainingResources);
        return this;
    }

    public List<Resource> getRegisteredResources() {
        if (this.registeredResources == null) {
            this.registeredResources = new SdkInternalList();
        }
        return this.registeredResources;
    }

    public void setRegisteredResources(Collection<Resource> registeredResources) {
        if (registeredResources == null) {
            this.registeredResources = null;
            return;
        }
        this.registeredResources = new SdkInternalList<Resource>(registeredResources);
    }

    public ContainerInstance withRegisteredResources(Resource ... registeredResources) {
        if (this.registeredResources == null) {
            this.setRegisteredResources(new SdkInternalList<Resource>(registeredResources.length));
        }
        for (Resource ele : registeredResources) {
            this.registeredResources.add(ele);
        }
        return this;
    }

    public ContainerInstance withRegisteredResources(Collection<Resource> registeredResources) {
        this.setRegisteredResources(registeredResources);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ContainerInstance withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setAgentConnected(Boolean agentConnected) {
        this.agentConnected = agentConnected;
    }

    public Boolean getAgentConnected() {
        return this.agentConnected;
    }

    public ContainerInstance withAgentConnected(Boolean agentConnected) {
        this.setAgentConnected(agentConnected);
        return this;
    }

    public Boolean isAgentConnected() {
        return this.agentConnected;
    }

    public void setRunningTasksCount(Integer runningTasksCount) {
        this.runningTasksCount = runningTasksCount;
    }

    public Integer getRunningTasksCount() {
        return this.runningTasksCount;
    }

    public ContainerInstance withRunningTasksCount(Integer runningTasksCount) {
        this.setRunningTasksCount(runningTasksCount);
        return this;
    }

    public void setPendingTasksCount(Integer pendingTasksCount) {
        this.pendingTasksCount = pendingTasksCount;
    }

    public Integer getPendingTasksCount() {
        return this.pendingTasksCount;
    }

    public ContainerInstance withPendingTasksCount(Integer pendingTasksCount) {
        this.setPendingTasksCount(pendingTasksCount);
        return this;
    }

    public void setAgentUpdateStatus(String agentUpdateStatus) {
        this.agentUpdateStatus = agentUpdateStatus;
    }

    public String getAgentUpdateStatus() {
        return this.agentUpdateStatus;
    }

    public ContainerInstance withAgentUpdateStatus(String agentUpdateStatus) {
        this.setAgentUpdateStatus(agentUpdateStatus);
        return this;
    }

    public void setAgentUpdateStatus(AgentUpdateStatus agentUpdateStatus) {
        this.withAgentUpdateStatus(agentUpdateStatus);
    }

    public ContainerInstance withAgentUpdateStatus(AgentUpdateStatus agentUpdateStatus) {
        this.agentUpdateStatus = agentUpdateStatus.toString();
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalList();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new SdkInternalList<Attribute>(attributes);
    }

    public ContainerInstance withAttributes(Attribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes(new SdkInternalList<Attribute>(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add(ele);
        }
        return this;
    }

    public ContainerInstance withAttributes(Collection<Attribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void setRegisteredAt(Date registeredAt) {
        this.registeredAt = registeredAt;
    }

    public Date getRegisteredAt() {
        return this.registeredAt;
    }

    public ContainerInstance withRegisteredAt(Date registeredAt) {
        this.setRegisteredAt(registeredAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: ").append(this.getContainerInstanceArn()).append(",");
        }
        if (this.getEc2InstanceId() != null) {
            sb.append("Ec2InstanceId: ").append(this.getEc2InstanceId()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getVersionInfo() != null) {
            sb.append("VersionInfo: ").append(this.getVersionInfo()).append(",");
        }
        if (this.getRemainingResources() != null) {
            sb.append("RemainingResources: ").append(this.getRemainingResources()).append(",");
        }
        if (this.getRegisteredResources() != null) {
            sb.append("RegisteredResources: ").append(this.getRegisteredResources()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAgentConnected() != null) {
            sb.append("AgentConnected: ").append(this.getAgentConnected()).append(",");
        }
        if (this.getRunningTasksCount() != null) {
            sb.append("RunningTasksCount: ").append(this.getRunningTasksCount()).append(",");
        }
        if (this.getPendingTasksCount() != null) {
            sb.append("PendingTasksCount: ").append(this.getPendingTasksCount()).append(",");
        }
        if (this.getAgentUpdateStatus() != null) {
            sb.append("AgentUpdateStatus: ").append(this.getAgentUpdateStatus()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getRegisteredAt() != null) {
            sb.append("RegisteredAt: ").append(this.getRegisteredAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerInstance)) {
            return false;
        }
        ContainerInstance other = (ContainerInstance)obj;
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null) {
            return false;
        }
        if (other.getContainerInstanceArn() != null && !other.getContainerInstanceArn().equals(this.getContainerInstanceArn())) {
            return false;
        }
        if (other.getEc2InstanceId() == null ^ this.getEc2InstanceId() == null) {
            return false;
        }
        if (other.getEc2InstanceId() != null && !other.getEc2InstanceId().equals(this.getEc2InstanceId())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getVersionInfo() == null ^ this.getVersionInfo() == null) {
            return false;
        }
        if (other.getVersionInfo() != null && !other.getVersionInfo().equals(this.getVersionInfo())) {
            return false;
        }
        if (other.getRemainingResources() == null ^ this.getRemainingResources() == null) {
            return false;
        }
        if (other.getRemainingResources() != null && !other.getRemainingResources().equals(this.getRemainingResources())) {
            return false;
        }
        if (other.getRegisteredResources() == null ^ this.getRegisteredResources() == null) {
            return false;
        }
        if (other.getRegisteredResources() != null && !other.getRegisteredResources().equals(this.getRegisteredResources())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAgentConnected() == null ^ this.getAgentConnected() == null) {
            return false;
        }
        if (other.getAgentConnected() != null && !other.getAgentConnected().equals(this.getAgentConnected())) {
            return false;
        }
        if (other.getRunningTasksCount() == null ^ this.getRunningTasksCount() == null) {
            return false;
        }
        if (other.getRunningTasksCount() != null && !other.getRunningTasksCount().equals(this.getRunningTasksCount())) {
            return false;
        }
        if (other.getPendingTasksCount() == null ^ this.getPendingTasksCount() == null) {
            return false;
        }
        if (other.getPendingTasksCount() != null && !other.getPendingTasksCount().equals(this.getPendingTasksCount())) {
            return false;
        }
        if (other.getAgentUpdateStatus() == null ^ this.getAgentUpdateStatus() == null) {
            return false;
        }
        if (other.getAgentUpdateStatus() != null && !other.getAgentUpdateStatus().equals(this.getAgentUpdateStatus())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getRegisteredAt() == null ^ this.getRegisteredAt() == null) {
            return false;
        }
        return other.getRegisteredAt() == null || other.getRegisteredAt().equals(this.getRegisteredAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerInstanceArn() == null ? 0 : this.getContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getEc2InstanceId() == null ? 0 : this.getEc2InstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getVersionInfo() == null ? 0 : this.getVersionInfo().hashCode());
        hashCode = 31 * hashCode + (this.getRemainingResources() == null ? 0 : this.getRemainingResources().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredResources() == null ? 0 : this.getRegisteredResources().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAgentConnected() == null ? 0 : this.getAgentConnected().hashCode());
        hashCode = 31 * hashCode + (this.getRunningTasksCount() == null ? 0 : this.getRunningTasksCount().hashCode());
        hashCode = 31 * hashCode + (this.getPendingTasksCount() == null ? 0 : this.getPendingTasksCount().hashCode());
        hashCode = 31 * hashCode + (this.getAgentUpdateStatus() == null ? 0 : this.getAgentUpdateStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredAt() == null ? 0 : this.getRegisteredAt().hashCode());
        return hashCode;
    }

    public ContainerInstance clone() {
        try {
            return (ContainerInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

